set VARS := 0..15;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.06;
let ub[0] := 2.84;
let lb[1] := 0.59;
let ub[1] := 2.31;
let lb[2] := 0.11;
let ub[2] := 2.6;
let lb[3] := 0.72;
let ub[3] := 2.2;
let lb[4] := 0.82;
let ub[4] := 2.48;
let lb[5] := 0.23;
let ub[5] := 2.51;
let lb[6] := 0.17;
let ub[6] := 2.34;
let lb[7] := 0.98;
let ub[7] := 2.11;
let lb[8] := 0.62;
let ub[8] := 2.63;
let lb[9] := 0.01;
let ub[9] := 2.11;
let lb[10] := 0.15;
let ub[10] := 2.1;
let lb[11] := 0.24;
let ub[11] := 2.74;
let lb[12] := 0.49;
let ub[12] := 2.92;
let lb[13] := 0.73;
let ub[13] := 2.91;
let lb[14] := 0.62;
let ub[14] := 2.27;
let lb[15] := 0.84;
let ub[15] := 2.09;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+9.04*X[0]	+7.4*X[1]	+5.5*X[2]	+3.11*X[3]	+6.41*X[4]	+3.71*X[5]	+5.62*X[6]	+2.09*X[7]	-7.03*X[8]	+3.56*X[9]	+2.46*X[10]	+8.37*X[11]	+3.08*X[12]	+6.43*X[13]	+5.85*X[14]	+6.48*X[15]	+4.19*X[6]*X[10]	+8.47*X[0]*X[0]*X[10]	+6.61*X[1]*X[9]*X[9]	+0.21*X[2]*X[2]*X[12]	+0.48*X[2]*X[3]*X[5]	+0.09*X[3]*X[10]*X[12]	+3.3*X[4]*X[4]*X[8]	+3.03*X[4]*X[7]*X[9]	+8.43*X[6]*X[7]*X[10]	+0.33*X[11]*X[12]*X[12];

subject to Constraint_1:
	+0.64*X[0]	+2.69*X[1]	+4.95*X[2]	+8.85*X[3]	+4.06*X[4]	-2.51*X[5]	+2.74*X[6]	+0.03*X[7]	+6.77*X[8]	+4.15*X[9]	+3.55*X[10]	+4.5*X[11]	+1.23*X[12]	+4.23*X[13]	+9.29*X[14]	+7.94*X[15]	+2.57*X[6]*X[10] >= 95.782;

subject to Constraint_2:
	-7.33*X[0]	-1.51*X[1]	+9.92*X[2]	+5.08*X[3]	-9.11*X[4]	+0.98*X[5]	+6.95*X[6]	-2.08*X[7]	+2.07*X[8]	+4.07*X[9]	+6.12*X[10]	+6.51*X[11]	-4.99*X[12]	+8.54*X[13]	-9.48*X[14]	+9.43*X[15]	+4.21*X[6]*X[10]	+2.04*X[0]*X[0]*X[10]	+0.58*X[1]*X[9]*X[9]	+9.41*X[2]*X[2]*X[12]	+4.23*X[2]*X[3]*X[5]	+3.45*X[3]*X[10]*X[12]	+0.18*X[4]*X[4]*X[8]	+9.9*X[4]*X[7]*X[9]	+3.62*X[6]*X[7]*X[10]	+7.78*X[11]*X[12]*X[12] >= 162.715;

subject to Constraint_3:
	+8.79*X[0]	+2.17*X[1]	+9.2*X[2]	+9.61*X[3]	+1.63*X[4]	+9.82*X[5]	+9.11*X[6]	+9.38*X[7]	+8.64*X[8]	+1.62*X[9]	-5.96*X[10]	-8.34*X[11]	+3.27*X[12]	+8.3*X[13]	+5.29*X[14]	-4.08*X[15]	+6.03*X[6]*X[10] >= 111.944;

subject to Constraint_4:
	+7.95*X[0]	+8.77*X[1]	+6.75*X[2]	+2.97*X[3]	+4.71*X[4]	+3.29*X[5]	+2.27*X[6]	+5.58*X[7]	+0.44*X[8]	+5.91*X[9]	+1.67*X[10]	+0.57*X[11]	+3.57*X[12]	+7.58*X[13]	+8.96*X[14]	+8.61*X[15]	+3.42*X[6]*X[10]	-6.99*X[0]*X[0]*X[10]	+6.63*X[1]*X[9]*X[9]	+8.99*X[2]*X[2]*X[12]	+4.83*X[2]*X[3]*X[5]	+9.92*X[3]*X[10]*X[12]	+0.34*X[4]*X[4]*X[8]	+9.4*X[4]*X[7]*X[9]	-8.39*X[6]*X[7]*X[10]	+3.96*X[11]*X[12]*X[12] >= 210.493;

subject to Constraint_5:
	+1.94*X[0]	+9.69*X[1]	+3.27*X[2]	+8.56*X[3]	+5.59*X[4]	+1*X[5]	+2.49*X[6]	+6.33*X[7]	+8.03*X[8]	+9.14*X[9]	+2.93*X[10]	+5.28*X[11]	+1.07*X[12]	+6.08*X[13]	+1.36*X[14]	+1.85*X[15]	+4.76*X[6]*X[10] >= 115.477;

subject to Constraint_6:
	+9.28*X[0]	+2.14*X[1]	+1.82*X[2]	+9.53*X[3]	+6.1*X[4]	+0.12*X[5]	+7.8*X[6]	+1.47*X[7]	+4.44*X[8]	+2.3*X[9]	-0.88*X[10]	+3.44*X[11]	-9.89*X[12]	+5.93*X[13]	+3.53*X[14]	+6.89*X[15] >= 78.142;

subject to Constraint_7:
	+3.02*X[0]	+8.51*X[1]	+2.61*X[2]	+4.84*X[3]	-1.08*X[4]	+5.66*X[5]	+6.55*X[6]	+1.8*X[7]	+6.85*X[8]	-5.6*X[9]	+9.08*X[10]	+4.68*X[11]	-1.73*X[12]	-7.77*X[13]	+9.17*X[14]	+4.1*X[15] >= 68.844;

subject to Constraint_8:
	+9.33*X[0]	+3.31*X[1]	+6.26*X[2]	+1.24*X[3]	+9.03*X[4]	+0.75*X[5]	+0.89*X[6]	+4.39*X[7]	-4.73*X[8]	+3.7*X[9]	+4.04*X[10]	+3.08*X[11]	+3.48*X[12]	+3.75*X[13]	+8.13*X[14]	+0.41*X[15] >= 82.924;

