set VARS := 0..15;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.23;
let ub[0] := 2.98;
let lb[1] := 0.53;
let ub[1] := 2.66;
let lb[2] := 0.62;
let ub[2] := 2.29;
let lb[3] := 0.07;
let ub[3] := 2.2;
let lb[4] := 0.36;
let ub[4] := 2.79;
let lb[5] := 0.58;
let ub[5] := 2.78;
let lb[6] := 0.37;
let ub[6] := 2.44;
let lb[7] := 0.99;
let ub[7] := 2.5;
let lb[8] := 0.94;
let ub[8] := 2.16;
let lb[9] := 0.75;
let ub[9] := 2.7;
let lb[10] := 0.45;
let ub[10] := 2.77;
let lb[11] := 0.14;
let ub[11] := 2.95;
let lb[12] := 0.72;
let ub[12] := 2.96;
let lb[13] := 0.68;
let ub[13] := 2.01;
let lb[14] := 0.87;
let ub[14] := 2.21;
let lb[15] := 0.89;
let ub[15] := 2.25;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+2.41*X[0]	+6.69*X[1]	+1.25*X[2]	+2.94*X[3]	+3.57*X[4]	+6.8*X[5]	+6.82*X[6]	+1.36*X[7]	+2.76*X[8]	+9.52*X[9]	+1.86*X[10]	-0.35*X[11]	+5.19*X[12]	+9.47*X[13]	+9.53*X[14]	-9.02*X[15]	+4.69*X[0]*X[5]	+3.93*X[1]*X[2]*X[9]	+1.01*X[1]*X[3]*X[10]	+7.46*X[4]*X[6]*X[7]	+6.75*X[6]*X[7]*X[8];

subject to Constraint_1:
	+0.39*X[0]	+1.95*X[1]	+8.95*X[2]	+6.04*X[3]	-0.71*X[4]	+2.15*X[5]	+3.36*X[6]	+6.82*X[7]	+1.9*X[8]	+0.94*X[9]	+0.74*X[10]	+8.04*X[11]	+2.57*X[12]	+8.62*X[13]	+1.89*X[14]	+9.94*X[15]	+0.77*X[0]*X[5] >= 97.824;

subject to Constraint_2:
	+0.9*X[0]	+6.25*X[1]	-2.23*X[2]	+7.68*X[3]	+4.75*X[4]	+7.26*X[5]	+1.69*X[6]	+9.01*X[7]	+6.82*X[8]	+6.04*X[9]	+9.67*X[10]	+5.22*X[11]	+0.03*X[12]	+7.39*X[13]	+6.98*X[14]	+8.59*X[15]	+6.71*X[0]*X[5]	+5.17*X[1]*X[2]*X[9]	+8.48*X[1]*X[3]*X[10]	+5.9*X[4]*X[6]*X[7]	+3.09*X[6]*X[7]*X[8] >= 231.545;

subject to Constraint_3:
	+4.12*X[0]	+1.33*X[1]	+3.83*X[2]	+0.7*X[3]	+0.78*X[4]	+1.05*X[5]	+3.08*X[6]	+9.41*X[7]	+0.06*X[8]	+5.47*X[9]	+8.61*X[10]	-7.3*X[11]	+6.46*X[12]	+6.7*X[13]	+8.51*X[14]	+5.73*X[15]	+6.78*X[0]*X[5] >= 112.235;

subject to Constraint_4:
	+3.83*X[0]	+5.22*X[1]	+6.38*X[2]	+7.92*X[3]	+3.4*X[4]	+1.19*X[5]	+3.81*X[6]	+6.57*X[7]	+4.01*X[8]	+9.84*X[9]	+1.96*X[10]	+7.14*X[11]	+0.62*X[12]	+3.96*X[13]	-8.66*X[14]	+3.07*X[15]	+5.81*X[0]*X[5]	+9.3*X[1]*X[2]*X[9]	+3.16*X[1]*X[3]*X[10]	+2.87*X[4]*X[6]*X[7]	+0.38*X[6]*X[7]*X[8] >= 166.877;

subject to Constraint_5:
	+3.09*X[0]	+2.95*X[1]	+7.55*X[2]	+5.54*X[3]	+9.41*X[4]	+6.36*X[5]	+2.24*X[6]	-4.1*X[7]	+4.82*X[8]	+5.39*X[9]	+7.94*X[10]	+4.33*X[11]	+1.92*X[12]	+8.41*X[13]	+8.84*X[14]	+8.16*X[15]	+5.91*X[0]*X[5] >= 141.883;

subject to Constraint_6:
	-4.13*X[0]	+3*X[1]	+7.34*X[2]	+1.27*X[3]	+7.71*X[4]	-8.92*X[5]	+5.12*X[6]	+3.44*X[7]	-2.81*X[8]	+8.86*X[9]	-5.57*X[10]	-6.57*X[11]	+2.07*X[12]	-3.82*X[13]	+1.91*X[14]	+3.93*X[15] = 20.224;

subject to Constraint_7:
	+6.68*X[0]	+3.39*X[1]	+9.62*X[2]	+3.18*X[3]	-8.29*X[4]	+8.07*X[5]	+9.64*X[6]	+7.99*X[7]	+3.35*X[8]	+2.41*X[9]	+9.43*X[10]	+5.33*X[11]	+4.81*X[12]	+5.67*X[13]	+5.93*X[14]	+6.89*X[15] = 130.915;

subject to Constraint_8:
	+6.57*X[0]	+6.02*X[1]	+7.98*X[2]	-5.45*X[3]	+1.43*X[4]	+4.37*X[5]	+7.21*X[6]	+2.1*X[7]	+5.96*X[8]	+8.57*X[9]	+9.41*X[10]	+5.59*X[11]	+1.91*X[12]	+9.17*X[13]	+0.1*X[14]	+9.61*X[15] = 127.858;

subject to Constraint_9:
	+6.21*X[0]	+1.94*X[1]	+9.11*X[2]	+7.97*X[3]	+8.42*X[4]	+0.11*X[5]	+6.17*X[6]	+5.8*X[7]	+2.1*X[8]	+6.16*X[9]	+9.76*X[10]	+4.27*X[11]	+3.76*X[12]	+5.83*X[13]	+6.81*X[14]	+4.67*X[15] = 136.369;

subject to Constraint_10:
	+0.19*X[0]	+7.75*X[1]	+7.62*X[2]	+2.81*X[3]	-9.01*X[4]	+1.73*X[5]	+3.65*X[6]	-6.29*X[7]	+5.03*X[8]	+5.63*X[9]	+3.58*X[10]	-6.77*X[11]	+9.56*X[12]	+3.68*X[13]	+5.27*X[14]	+1.32*X[15] = 55.351;

subject to Constraint_11:
	+1.15*X[0]	+4.07*X[1]	+3.62*X[2]	+4.2*X[3]	+3.65*X[4]	+4.23*X[5]	+5.14*X[6]	+0.11*X[7]	+7.11*X[8]	+2.76*X[9]	+9.5*X[10]	+1.32*X[11]	+7.6*X[12]	+6.07*X[13]	+3.95*X[14]	+5.61*X[15] = 108.795;

subject to Constraint_12:
	-8.99*X[0]	+4.19*X[1]	+1.82*X[2]	+5.15*X[3]	+8.46*X[4]	+6.15*X[5]	+6.48*X[6]	+7.46*X[7]	+9.73*X[8]	+6.93*X[9]	+6.18*X[10]	+5.77*X[11]	+7.24*X[12]	+6.27*X[13]	-0.89*X[14]	+4.44*X[15] = 119.781;

subject to Constraint_13:
	+1.55*X[0]	+4.65*X[1]	+5.8*X[2]	+5.84*X[3]	+6.74*X[4]	+2.45*X[5]	+0.3*X[6]	+8.69*X[7]	+4.6*X[8]	+8.21*X[9]	-6.96*X[10]	+2.12*X[11]	+7.29*X[12]	+0.03*X[13]	+6.47*X[14]	+7.33*X[15] = 103.577;

subject to Constraint_14:
	+7.18*X[0]	+2.48*X[1]	-0.68*X[2]	+1.36*X[3]	-3.47*X[4]	+5.58*X[5]	+2.05*X[6]	+2.58*X[7]	+3.24*X[8]	+8.58*X[9]	+4.88*X[10]	+9*X[11]	+3.13*X[12]	-0.33*X[13]	+8.05*X[14]	+2.89*X[15] >= 91.159;

subject to Constraint_15:
	+3.16*X[0]	+5.79*X[1]	+9.74*X[2]	+9.44*X[3]	+6.36*X[4]	+9.36*X[5]	+8.52*X[6]	+1.31*X[7]	+7.09*X[8]	+9.19*X[9]	-0.83*X[10]	+7.91*X[11]	+1.1*X[12]	+1.94*X[13]	+3.03*X[14]	+5.99*X[15] >= 135.622;

subject to Constraint_16:
	+0.24*X[0]	-7.87*X[1]	+9.7*X[2]	-3.07*X[3]	-7.42*X[4]	+7.27*X[5]	+8.19*X[6]	+4.65*X[7]	-5.09*X[8]	+4.94*X[9]	+9.38*X[10]	-6.22*X[11]	+7.62*X[12]	+7.76*X[13]	+5.69*X[14]	-6.05*X[15] >= 48.456;

