set VARS := 0..11;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.53;
let ub[0] := 2.79;
let lb[1] := 0.83;
let ub[1] := 2.71;
let lb[2] := 0.2;
let ub[2] := 2.3;
let lb[3] := 0.02;
let ub[3] := 2.13;
let lb[4] := 0.7;
let ub[4] := 2.47;
let lb[5] := 0.46;
let ub[5] := 2.7;
let lb[6] := 0.07;
let ub[6] := 2.77;
let lb[7] := 0.75;
let ub[7] := 2.31;
let lb[8] := 0.27;
let ub[8] := 2.64;
let lb[9] := 0.56;
let ub[9] := 2.96;
let lb[10] := 0.76;
let ub[10] := 2.53;
let lb[11] := 0.3;
let ub[11] := 2.28;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+7.27*X[0]	+0.5*X[1]	+8.28*X[2]	+4.48*X[3]	+9.78*X[4]	+8.44*X[5]	+8.83*X[6]	+2.28*X[7]	+2.29*X[8]	+8.7*X[9]	-4.32*X[10]	+9.7*X[11]	+0.05*X[1]*X[2]*X[7]	+8.61*X[2]*X[3]*X[7]	-7.82*X[0]*X[0]*X[1]*X[4]	+6.67*X[1]*X[3]*X[3]*X[7]	+2.74*X[1]*X[3]*X[6]*X[8]	+4.86*X[2]*X[5]*X[7]*X[7]	+1.69*X[2]*X[9]*X[9]*X[9]	+5.98*X[3]*X[5]*X[5]*X[6]	+8.32*X[7]*X[8]*X[9]*X[9];

subject to Constraint_1:
	+1.83*X[0]	+5.28*X[1]	+6.99*X[2]	+9.88*X[3]	+3.96*X[4]	+2.35*X[5]	-4.43*X[6]	+9.71*X[7]	-1.66*X[8]	+7.27*X[9]	+3.73*X[10]	+2.89*X[11]	+8.87*X[2]*X[3]*X[7]	-0.05*X[1]*X[2]*X[7] >= 88.608;

subject to Constraint_2:
	+8.16*X[0]	+1.45*X[1]	+7.04*X[2]	-0.51*X[3]	-1.96*X[4]	+3.17*X[5]	+2.65*X[6]	+9.9*X[7]	+1.8*X[8]	+0.73*X[9]	+4.26*X[10]	-6.13*X[11]	+6.71*X[1]*X[2]*X[7]	+0.86*X[2]*X[3]*X[7]	+8.98*X[0]*X[0]*X[1]*X[4]	+6.62*X[1]*X[3]*X[3]*X[7]	+7.35*X[1]*X[3]*X[6]*X[8]	+7.02*X[2]*X[5]*X[7]*X[7]	+6.39*X[2]*X[9]*X[9]*X[9]	-5.68*X[3]*X[5]*X[5]*X[6]	+0.68*X[7]*X[8]*X[9]*X[9] >= 250.742;

subject to Constraint_3:
	+9.54*X[0]	+8.84*X[1]	+6.64*X[2]	-8.24*X[3]	+7.8*X[4]	+2.83*X[5]	+3.93*X[6]	+6.87*X[7]	+1.53*X[8]	+4.46*X[9]	+3.26*X[10]	+0.09*X[11] >= 79.406;

subject to Constraint_4:
	+5.32*X[0]	+8.93*X[1]	+2.38*X[2]	+5.48*X[3]	-3.53*X[4]	+8.83*X[5]	+9.45*X[6]	+5.5*X[7]	+0.54*X[8]	+7.04*X[9]	+8.43*X[10]	+2.07*X[11] >= 93.407;

subject to Constraint_5:
	+0.69*X[0]	+5.66*X[1]	+5.05*X[2]	+4.34*X[3]	+9.37*X[4]	+3.28*X[5]	-0.86*X[6]	+7.22*X[7]	+1.1*X[8]	+5.06*X[9]	+3.84*X[10]	+0.16*X[11] >= 69.03;

subject to Constraint_6:
	+1.45*X[0]	+4.07*X[1]	+3.52*X[2]	+2.69*X[3]	+0.05*X[4]	-3.12*X[5]	+0.28*X[6]	+0.74*X[7]	+4.67*X[8]	+6.32*X[9]	+4.46*X[10]	+0.17*X[11] >= 39.056;

