set VARS := 0..11;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.12;
let ub[0] := 2.19;
let lb[1] := 0.47;
let ub[1] := 2.06;
let lb[2] := 0.85;
let ub[2] := 2.53;
let lb[3] := 0.8;
let ub[3] := 2.24;
let lb[4] := 0.33;
let ub[4] := 2.74;
let lb[5] := 0.29;
let ub[5] := 2.06;
let lb[6] := 0.85;
let ub[6] := 2.67;
let lb[7] := 0.82;
let ub[7] := 2.28;
let lb[8] := 0.54;
let ub[8] := 2.22;
let lb[9] := 0.02;
let ub[9] := 2.46;
let lb[10] := 0.23;
let ub[10] := 2.14;
let lb[11] := 0.87;
let ub[11] := 2.03;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+3.8*X[0]	+7.03*X[1]	+2.79*X[2]	+3.33*X[3]	+3.19*X[4]	+3.7*X[5]	+3.11*X[6]	+6.01*X[7]	+9.01*X[8]	+1.3*X[9]	+0.75*X[10]	+4.44*X[11]	+4.7*X[1]*X[1]*X[7]	+9.21*X[1]*X[3]*X[6]	-6.84*X[4]*X[4]*X[6]	+6.04*X[0]*X[5]*X[5]*X[5]	+8.78*X[1]*X[1]*X[5]*X[7]	+8.34*X[1]*X[2]*X[3]*X[9]	+6.79*X[1]*X[6]*X[6]*X[9]	+7.41*X[2]*X[2]*X[4]*X[6]	+5.35*X[6]*X[7]*X[8]*X[8];

subject to Constraint_1:
	+6.68*X[0]	+1.43*X[1]	+4.31*X[2]	+5.78*X[3]	+1.49*X[4]	+8.92*X[5]	+8.73*X[6]	+8.61*X[7]	+5.39*X[8]	-2.45*X[9]	+2.4*X[10]	+9.9*X[11]	+6.3*X[1]*X[1]*X[7]	+6.14*X[1]*X[3]*X[6]	+2.12*X[4]*X[4]*X[6] >= 133.868;

subject to Constraint_2:
	+0.25*X[0]	+8.22*X[1]	+1.42*X[2]	+5.64*X[3]	+0.81*X[4]	+9.98*X[5]	+5.7*X[6]	+8.52*X[7]	+5.95*X[8]	+4.85*X[9]	-0.33*X[10]	+7.94*X[11]	+4.03*X[1]*X[1]*X[7]	+9.15*X[1]*X[3]*X[6]	+0.18*X[4]*X[4]*X[6]	+9.13*X[0]*X[5]*X[5]*X[5]	-9.63*X[1]*X[1]*X[5]*X[7]	-5.09*X[1]*X[2]*X[3]*X[9]	+5.43*X[1]*X[6]*X[6]*X[9]	-6.93*X[2]*X[2]*X[4]*X[6]	+9.59*X[6]*X[7]*X[8]*X[8] >= 116.186;

subject to Constraint_3:
	-5.77*X[0]	+2.14*X[3]	+3.58*X[4]	+5.38*X[7]	+2.22*X[9]	+3.13*X[11] = 17.714;

subject to Constraint_4:
	+5.09*X[0]	+8.46*X[3]	+4.44*X[4]	+3.72*X[5]	+1.83*X[7]	+8.69*X[9] = 43.537;

subject to Constraint_5:
	+6.62*X[2]	-5.9*X[3]	+8.64*X[4]	-2.39*X[5]	+4.63*X[8]	+8.64*X[10] = 29.302;

subject to Constraint_6:
	+0.95*X[0]	-5.83*X[1]	+9.3*X[2]	+2.83*X[3]	+0.77*X[4]	+3.9*X[5]	-8.3*X[6]	+1.83*X[7]	+4.69*X[8]	-8.98*X[9]	+8.22*X[10]	+2.88*X[11] >= 16.988;

subject to Constraint_7:
	+8.84*X[0]	+1.91*X[1]	+2*X[2]	+4.1*X[3]	+3.93*X[4]	+1.77*X[5]	+0.31*X[6]	+0.72*X[7]	-6.56*X[8]	+5.83*X[9]	+9.86*X[10]	+2.57*X[11] >= 45.599;

subject to Constraint_8:
	+9.26*X[0]	+1.76*X[1]	+1.81*X[2]	-5.16*X[3]	+5.34*X[4]	+2.63*X[5]	+8.51*X[6]	+0.54*X[7]	+5.85*X[8]	+7.58*X[9]	+3.51*X[10]	+2.33*X[11] >= 60.249;

subject to Constraint_9:
	+4.66*X[0]	+4.76*X[1]	+4.8*X[2]	+6.75*X[3]	+5.83*X[4]	+0.65*X[5]	+5.62*X[6]	+4.38*X[7]	+8.58*X[8]	+6.14*X[9]	+4.8*X[10]	+0.78*X[11] >= 82.442;

