set VARS := 0..11;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.78;
let ub[0] := 2.34;
let lb[1] := 0.78;
let ub[1] := 2.47;
let lb[2] := 0.73;
let ub[2] := 2.23;
let lb[3] := 0.72;
let ub[3] := 2.28;
let lb[4] := 0.22;
let ub[4] := 2.74;
let lb[5] := 0.41;
let ub[5] := 2.67;
let lb[6] := 0.94;
let ub[6] := 2.2;
let lb[7] := 0.22;
let ub[7] := 2.05;
let lb[8] := 0.41;
let ub[8] := 2.65;
let lb[9] := 0.94;
let ub[9] := 2.54;
let lb[10] := 0.55;
let ub[10] := 2.02;
let lb[11] := 0;
let ub[11] := 2.64;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+7.37*X[0]	+8.25*X[1]	+1.87*X[2]	+5.68*X[3]	+5.71*X[4]	+0.78*X[5]	-7.8*X[6]	+3.99*X[7]	+5.55*X[8]	+1.25*X[9]	+9.76*X[10]	+0.15*X[11]	+8.1*X[8]*X[8]	+4.18*X[0]*X[4]*X[7]	+3.43*X[1]*X[3]*X[4]	+6.12*X[6]*X[6]*X[10]	+7.98*X[0]*X[1]*X[1]*X[9]	+5.1*X[1]*X[2]*X[2]*X[4]	+4.01*X[1]*X[2]*X[2]*X[9]	+2.77*X[2]*X[2]*X[7]*X[10]	+7.89*X[5]*X[5]*X[8]*X[10];

subject to Constraint_1:
	+7.04*X[0]	+0.44*X[1]	+2.1*X[2]	+8.51*X[3]	-4.03*X[4]	+3.33*X[5]	+4.67*X[6]	+0.99*X[7]	+2.38*X[8]	+9.01*X[9]	+0.08*X[10]	+3.96*X[11]	+8.64*X[8]*X[8] >= 80.064;

subject to Constraint_2:
	+8.37*X[0]	+0.28*X[1]	+7.43*X[2]	+4.27*X[3]	+6.36*X[4]	+6.08*X[5]	+7.88*X[6]	+7.74*X[7]	+2.01*X[8]	+2.91*X[9]	+9.58*X[10]	+6.49*X[11]	+7.28*X[8]*X[8]	+4.21*X[0]*X[4]*X[7]	+4.38*X[1]*X[3]*X[4]	+8.21*X[6]*X[6]*X[10] >= 169.741;

subject to Constraint_3:
	+0.83*X[0]	+2.74*X[1]	+9.84*X[2]	+1.21*X[3]	-4.28*X[4]	+6.14*X[5]	+5.78*X[6]	+3.74*X[7]	+2.99*X[8]	+3.39*X[9]	-1.26*X[10]	+0.02*X[11]	+6.98*X[8]*X[8]	-6.15*X[0]*X[4]*X[7]	+2.08*X[1]*X[3]*X[4]	+2.73*X[6]*X[6]*X[10]	-6.16*X[0]*X[1]*X[1]*X[9]	+5.78*X[1]*X[2]*X[2]*X[4]	+1.39*X[1]*X[2]*X[2]*X[9]	+5.92*X[2]*X[2]*X[7]*X[10]	+1.74*X[5]*X[5]*X[8]*X[10] >= 85.75;

subject to Constraint_4:
	+1.17*X[0]	+3.01*X[1]	+1.78*X[2]	+4.07*X[3]	+5.97*X[4]	+1.58*X[5]	+3.12*X[6]	+8.67*X[7]	+1.94*X[8]	+2.02*X[9]	+4.31*X[10]	+6.77*X[11]	+2.35*X[8]*X[8] >= 67.922;

subject to Constraint_5:
	-5.85*X[0]	+2.93*X[1]	+9.27*X[2]	+6.11*X[3]	+3.31*X[4]	+4.2*X[5]	+2.49*X[6]	+1*X[7]	+7.1*X[8]	+5.94*X[9]	+9.54*X[10]	+3.58*X[11] = 73.114;

subject to Constraint_6:
	+0.52*X[0]	+1.29*X[1]	+0.54*X[2]	+1.78*X[3]	+6.46*X[4]	+9.13*X[5]	-4.31*X[6]	+3.05*X[7]	+7.75*X[8]	-5.58*X[9]	+2.06*X[10]	+9.7*X[11] = 44.292;

subject to Constraint_7:
	-2.6*X[0]	+0.4*X[1]	+8.4*X[2]	+2.08*X[3]	+0.25*X[4]	+3.38*X[5]	+4.24*X[6]	+5.79*X[7]	+4.15*X[8]	+9.48*X[9]	+4.94*X[10]	+0.16*X[11] = 60.353;

subject to Constraint_8:
	+3.63*X[0]	+9.6*X[1]	+9.18*X[2]	-4.94*X[3]	+7.39*X[4]	+9.54*X[5]	-9*X[6]	+6.44*X[7]	+5.58*X[8]	+3.06*X[9]	+6.56*X[10]	-3.79*X[11] = 63.536;

subject to Constraint_9:
	+1.94*X[0]	+7.93*X[1]	+9.73*X[2]	+8.85*X[3]	-7.94*X[4]	+9.7*X[5]	-9.91*X[6]	+0.04*X[7]	+6.55*X[8]	+5.34*X[9]	+1.18*X[10]	+0.37*X[11] = 52.579;

subject to Constraint_10:
	-6.74*X[0]	-4.56*X[1]	-9.17*X[2]	+0.18*X[3]	+7.94*X[4]	+6.38*X[5]	+3.44*X[6]	+4.29*X[7]	+0.83*X[8]	+9.88*X[9]	+9.21*X[10]	+6.15*X[11] = 39.034;

subject to Constraint_11:
	+3.89*X[0]	-4.48*X[1]	-0.66*X[2]	+6.94*X[3]	-5.07*X[4]	+7.94*X[5]	+0.53*X[6]	+1.04*X[7]	+6.92*X[8]	+6.94*X[9]	+6.05*X[10]	+3.64*X[11] >= 50.2;

subject to Constraint_12:
	-5.48*X[0]	+8.74*X[1]	+3.37*X[2]	+7.68*X[3]	+2.91*X[4]	+1.73*X[5]	+7.9*X[6]	+7.78*X[7]	+4.68*X[8]	+0.49*X[9]	+3.98*X[10]	-0.62*X[11] >= 62.675;

