set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.31;
let ub[0] := 2.75;
let lb[1] := 0.33;
let ub[1] := 2.04;
let lb[2] := 0.91;
let ub[2] := 2.78;
let lb[3] := 0.75;
let ub[3] := 2.36;
let lb[4] := 0.75;
let ub[4] := 2.05;
let lb[5] := 0.6;
let ub[5] := 2.79;
let lb[6] := 0.05;
let ub[6] := 2.56;
let lb[7] := 0.88;
let ub[7] := 2.07;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+5.95*X[0]	+4.73*X[1]	+0.32*X[2]	+6.44*X[3]	+8.73*X[4]	+1.59*X[5]	+3.48*X[6]	+9.77*X[7]	+0.76*X[4]*X[5]	+0.84*X[0]*X[0]*X[1]	+6.94*X[0]*X[0]*X[3]	+9.71*X[0]*X[3]*X[5]	+2.76*X[2]*X[2]*X[3]	+1.92*X[5]*X[6]*X[6]*X[6]	+0.24*X[0]*X[4]*X[4]*X[4]*X[4]	-3.77*X[1]*X[1]*X[1]*X[2]*X[3]	+7.03*X[1]*X[1]*X[1]*X[6]*X[6]	+3.89*X[1]*X[3]*X[3]*X[5]*X[5]	+0.19*X[1]*X[3]*X[3]*X[5]*X[6]	+0.26*X[2]*X[4]*X[4]*X[4]*X[5]	+1.76*X[3]*X[4]*X[4]*X[5]*X[5];

subject to Constraint_1:
	+5.91*X[0]	+7.23*X[1]	+0.27*X[2]	+6.12*X[3]	-2.95*X[4]	+3.49*X[5]	+6.76*X[6]	+2.85*X[7]	+8.22*X[4]*X[5] >= 61.942;

subject to Constraint_2:
	+6.83*X[0]	+5.15*X[1]	+7.65*X[2]	+9.36*X[3]	+1.01*X[4]	+7.55*X[5]	+0.36*X[6]	-0.73*X[7]	+7.16*X[4]*X[5]	+7.34*X[0]*X[0]*X[1]	+2.44*X[0]*X[0]*X[3]	+2.43*X[0]*X[3]*X[5]	+4.29*X[2]*X[2]*X[3] >= 137.567;

subject to Constraint_3:
	+0.17*X[0]	+3.46*X[1]	+6.04*X[2]	+7.39*X[3]	+0.18*X[4]	+4.26*X[5]	+7.2*X[6]	+6.23*X[7]	+3.06*X[4]*X[5]	+1.31*X[0]*X[0]*X[1]	-7.31*X[0]*X[0]*X[3]	+1.43*X[0]*X[3]*X[5]	+9.39*X[2]*X[2]*X[3]	+5.99*X[5]*X[6]*X[6]*X[6] >= 115.375;

subject to Constraint_4:
	+8.38*X[0]	+7.09*X[1]	+6.13*X[2]	+7.3*X[3]	+0.74*X[4]	+9.28*X[5]	+6.24*X[6]	+4.14*X[7]	+6*X[4]*X[5]	+0.38*X[0]*X[0]*X[1]	+7.84*X[0]*X[0]*X[3]	+3.31*X[0]*X[3]*X[5]	+3.72*X[2]*X[2]*X[3]	-7.57*X[5]*X[6]*X[6]*X[6]	+9.03*X[0]*X[4]*X[4]*X[4]*X[4]	+5.26*X[1]*X[1]*X[1]*X[2]*X[3]	+2.22*X[1]*X[1]*X[1]*X[6]*X[6]	+8.83*X[1]*X[3]*X[3]*X[5]*X[5]	+4.67*X[1]*X[3]*X[3]*X[5]*X[6]	+3.09*X[2]*X[4]*X[4]*X[4]*X[5]	-0.67*X[3]*X[4]*X[4]*X[5]*X[5] >= 330.669;

subject to Constraint_5:
	+9.57*X[2]	+3.17*X[3]	+3.63*X[4]	+9.45*X[6] = 40;

subject to Constraint_6:
	-2.68*X[0]	+9.09*X[1]	+0.06*X[5]	+1.38*X[6] = 8.574;

subject to Constraint_7:
	+1.75*X[0]	+7.61*X[1]	+5.47*X[2]	+7.16*X[3]	+6.29*X[4]	+6.45*X[5]	+7.39*X[6]	+1.88*X[7] >= 65.077;

