set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.86;
let ub[0] := 2.84;
let lb[1] := 0.23;
let ub[1] := 2.67;
let lb[2] := 0.15;
let ub[2] := 2.91;
let lb[3] := 0.93;
let ub[3] := 2.82;
let lb[4] := 0.37;
let ub[4] := 2.25;
let lb[5] := 0.05;
let ub[5] := 2.7;
let lb[6] := 0.99;
let ub[6] := 2.6;
let lb[7] := 0.35;
let ub[7] := 2.7;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+3.72*X[0]	+2.89*X[1]	+9.19*X[2]	+2.48*X[3]	+0.78*X[4]	+4.32*X[5]	+8.62*X[6]	+8.1*X[7]	+6.67*X[0]*X[3]*X[4]	+0.07*X[0]*X[3]*X[5]	+6.34*X[0]*X[1]*X[2]*X[2]	+7.99*X[2]*X[2]*X[2]*X[5]	+3.05*X[5]*X[6]*X[6]*X[7]	+2.86*X[0]*X[0]*X[3]*X[6]*X[7]	+4.92*X[1]*X[3]*X[3]*X[5]*X[7]	-9.18*X[2]*X[2]*X[4]*X[4]*X[4]	+7.45*X[2]*X[3]*X[3]*X[3]*X[5]	+0.27*X[2]*X[6]*X[6]*X[6]*X[6]	+3.49*X[3]*X[3]*X[4]*X[4]*X[4]	-0.06*X[3]*X[3]*X[4]*X[5]*X[6]	+2.42*X[4]*X[5]*X[5]*X[6]*X[6];

subject to Constraint_1:
	+9.17*X[0]	+8.63*X[1]	+5.83*X[2]	+8.16*X[3]	+8.6*X[4]	-4.99*X[5]	+9.37*X[6]	+6.38*X[7]	+5.76*X[0]*X[3]*X[4]	+0.75*X[0]*X[3]*X[5] >= 114.402;

subject to Constraint_2:
	+1.6*X[0]	+4.3*X[1]	+8.77*X[2]	+0.38*X[3]	+4.61*X[4]	+8.37*X[5]	+3.82*X[6]	+3.44*X[7]	+8.98*X[0]*X[3]*X[4]	+3.84*X[0]*X[3]*X[5]	+8.8*X[0]*X[1]*X[2]*X[2]	+7.3*X[2]*X[2]*X[2]*X[5]	+8.03*X[5]*X[6]*X[6]*X[7] >= 257.559;

subject to Constraint_3:
	+3.06*X[0]	+8.2*X[1]	+1.09*X[2]	-3.29*X[3]	+5.1*X[4]	-9.21*X[5]	+0.88*X[6]	+1.33*X[7]	+6.53*X[0]*X[3]*X[4]	+9.11*X[0]*X[3]*X[5]	+6.12*X[0]*X[1]*X[2]*X[2]	-1.72*X[2]*X[2]*X[2]*X[5]	+3.47*X[5]*X[6]*X[6]*X[7]	+3.94*X[0]*X[0]*X[3]*X[6]*X[7]	+7.36*X[1]*X[3]*X[3]*X[5]*X[7]	+6.27*X[2]*X[2]*X[4]*X[4]*X[4]	+4.99*X[2]*X[3]*X[3]*X[3]*X[5]	-8.32*X[2]*X[6]*X[6]*X[6]*X[6]	+5.16*X[3]*X[3]*X[4]*X[4]*X[4]	+9.6*X[3]*X[3]*X[4]*X[5]*X[6]	+7.61*X[4]*X[5]*X[5]*X[6]*X[6] >= 465.761;

subject to Constraint_4:
	+8.32*X[0]	+2.3*X[1]	+4.74*X[2]	-8.19*X[3]	+2.8*X[4]	+4.81*X[5]	+9.38*X[6]	+3.64*X[7] = 43.293;

subject to Constraint_5:
	+3.52*X[0]	+9.66*X[1]	-7.16*X[2]	+7.37*X[3]	+6.48*X[4]	+3.32*X[5]	+7.65*X[6]	-0.52*X[7] = 49.376;

subject to Constraint_6:
	-0.08*X[0]	+0.9*X[1]	+9.95*X[2]	+0.61*X[3]	+5.67*X[4]	+6.41*X[5]	+9.16*X[6]	+9.63*X[7] >= 64.894;

subject to Constraint_7:
	+8.26*X[0]	+4.41*X[1]	+2.04*X[2]	+7.92*X[3]	+5.02*X[4]	+0.88*X[5]	+4.36*X[6]	+4.95*X[7] >= 62.808;

