set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.58;
let ub[0] := 2.68;
let lb[1] := 0.49;
let ub[1] := 2.8;
let lb[2] := 0.92;
let ub[2] := 2.1;
let lb[3] := 0.54;
let ub[3] := 2.97;
let lb[4] := 0.89;
let ub[4] := 2.49;
let lb[5] := 0.33;
let ub[5] := 2.01;
let lb[6] := 0.45;
let ub[6] := 2.8;
let lb[7] := 0.1;
let ub[7] := 2.67;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+6.66*X[0]	+3.86*X[1]	+0.87*X[2]	+1.34*X[3]	+0.93*X[4]	+8.63*X[5]	+0.78*X[6]	+4.32*X[7]	+4.93*X[3]*X[6]*X[6]	+3.4*X[0]*X[1]*X[3]*X[6]	+8.16*X[0]*X[3]*X[7]*X[7]	+7.33*X[5]*X[5]*X[7]*X[7]	-8.52*X[0]*X[0]*X[1]*X[5]*X[7]	+3.06*X[0]*X[0]*X[3]*X[4]*X[6]	+1.23*X[0]*X[1]*X[7]*X[7]*X[7]	+1.43*X[0]*X[4]*X[4]*X[4]*X[4]	+6.6*X[1]*X[1]*X[1]*X[2]*X[2]	+0.15*X[1]*X[4]*X[4]*X[4]*X[6]	+9.46*X[2]*X[2]*X[4]*X[6]*X[6]	+1.75*X[2]*X[5]*X[6]*X[7]*X[7]	+3.18*X[3]*X[3]*X[3]*X[6]*X[7];

subject to Constraint_1:
	+0.34*X[0]	+6.43*X[1]	+7.87*X[2]	+1.82*X[3]	+9.74*X[4]	+8.91*X[5]	+6.06*X[6]	+4.99*X[7]	-0.65*X[3]*X[6]*X[6] >= 66.841;

subject to Constraint_2:
	+7.32*X[0]	+4.48*X[1]	-6.54*X[2]	+9.25*X[3]	+1.01*X[4]	+8.8*X[5]	+2.33*X[6]	+1.27*X[7]	+7.37*X[3]*X[6]*X[6]	+9.85*X[0]*X[1]*X[3]*X[6]	+7.1*X[0]*X[3]*X[7]*X[7]	+4.78*X[5]*X[5]*X[7]*X[7] >= 204.196;

subject to Constraint_3:
	+7.56*X[0]	+4.59*X[1]	+3.27*X[2]	+9.3*X[3]	+8.38*X[4]	+3.34*X[5]	+5.93*X[6]	+1.18*X[7]	+0.44*X[3]*X[6]*X[6]	+3.25*X[0]*X[1]*X[3]*X[6]	+4.19*X[0]*X[3]*X[7]*X[7]	+5.18*X[5]*X[5]*X[7]*X[7]	+2.57*X[0]*X[0]*X[1]*X[5]*X[7]	+8.01*X[0]*X[0]*X[3]*X[4]*X[6]	+8.66*X[0]*X[1]*X[7]*X[7]*X[7]	-2.31*X[0]*X[4]*X[4]*X[4]*X[4]	+2.51*X[1]*X[1]*X[1]*X[2]*X[2]	+3.88*X[1]*X[4]*X[4]*X[4]*X[6]	+5.3*X[2]*X[2]*X[4]*X[6]*X[6]	+3.99*X[2]*X[5]*X[6]*X[7]*X[7]	+3.81*X[3]*X[3]*X[3]*X[6]*X[7] >= 483.498;

subject to Constraint_4:
	+5.54*X[0]	+3.25*X[1]	+7.89*X[2]	+0.38*X[3]	+7.52*X[4]	+9.14*X[5]	+6.76*X[6]	+6.84*X[7] = 70.818;

subject to Constraint_5:
	+9.79*X[0]	+8.68*X[1]	+1.74*X[2]	+2.66*X[3]	+0.64*X[4]	+8.43*X[5]	+8.79*X[6]	+6.8*X[7] = 72.178;

subject to Constraint_6:
	-4.88*X[0]	+3.6*X[1]	-9.82*X[2]	+1.72*X[3]	-5.45*X[4]	+7.16*X[5]	+2.2*X[6]	+5.03*X[7] = -4.134;

subject to Constraint_7:
	+6.03*X[0]	+2.4*X[1]	+7.08*X[2]	+7.12*X[3]	+9.82*X[4]	+9.6*X[5]	+0.14*X[6]	+2.71*X[7] = 68.772;

subject to Constraint_8:
	+1.79*X[0]	+9.46*X[1]	+4.41*X[2]	+8.9*X[3]	+6.86*X[4]	+8.37*X[5]	+9.62*X[6]	+7.41*X[7] >= 88.04;

subject to Constraint_9:
	+5.41*X[0]	+2.05*X[1]	+3.09*X[2]	+2.52*X[3]	+9.14*X[4]	-9.21*X[5]	+4.64*X[6]	-7.49*X[7] >= 23.116;

