set VARS := 0..5;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.52;
let ub[0] := 2.08;
let lb[1] := 0.39;
let ub[1] := 2.06;
let lb[2] := 0.2;
let ub[2] := 2.83;
let lb[3] := 0.49;
let ub[3] := 2.6;
let lb[4] := 0;
let ub[4] := 2.46;
let lb[5] := 0.89;
let ub[5] := 2.96;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+9.95*X[0]	-4.01*X[1]	+0.07*X[2]	+0.9*X[3]	+0.96*X[4]	+2.24*X[5]	-4.07*X[2]*X[3]*X[4]	+3.36*X[0]*X[1]*X[4]*X[4]	+4.97*X[0]*X[0]*X[3]*X[3]*X[3]*X[5]	+8.48*X[1]*X[3]*X[4]*X[5]*X[5]*X[5]	+0.1*X[2]*X[2]*X[2]*X[5]*X[5]*X[5];

subject to Constraint_1:
	+5.58*X[0]	+2.62*X[1]	+4.08*X[2]	+5.05*X[3]	+8.66*X[4]	+4.6*X[5]	+5.13*X[2]*X[3]*X[4] >= 58.723;

subject to Constraint_2:
	+9.99*X[0]	+9*X[1]	+1.72*X[2]	+6.26*X[3]	-8.5*X[4]	+4.77*X[5]	+8.33*X[2]*X[3]*X[4]	+4.35*X[0]*X[1]*X[4]*X[4] >= 69.479;

subject to Constraint_3:
	+8.91*X[0]	+1.97*X[1]	+3.9*X[2]	+6.82*X[3]	+0.44*X[4]	+7.57*X[5]	+9.45*X[2]*X[3]*X[4]	+1.25*X[0]*X[1]*X[4]*X[4] >= 75.774;

subject to Constraint_4:
	+9.91*X[0]	+7.41*X[1]	+1.27*X[2]	+0.26*X[3]	+8.02*X[4]	+8.67*X[5] >= 50.84;

subject to Constraint_5:
	+7.67*X[0]	+5.58*X[1]	+2.95*X[2]	+3*X[3]	+1.79*X[4]	+0.43*X[5] >= 28.94;

