set VARS := 0..5;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.87;
let ub[0] := 2.27;
let lb[1] := 0.61;
let ub[1] := 2.54;
let lb[2] := 0.66;
let ub[2] := 2.64;
let lb[3] := 0.15;
let ub[3] := 2.34;
let lb[4] := 0.91;
let ub[4] := 2.28;
let lb[5] := 0.04;
let ub[5] := 2.13;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+9.95*X[0]	+2.41*X[1]	+2.84*X[2]	+8.42*X[3]	+9.47*X[4]	+1.56*X[5]	+1.86*X[0]*X[0]*X[5]	+2.09*X[0]*X[1]*X[1]*X[5]	+2.9*X[0]*X[3]*X[5]*X[5]	-0.41*X[1]*X[2]*X[2]*X[3]	+4.82*X[0]*X[0]*X[2]*X[2]*X[2]	+5.5*X[0]*X[0]*X[5]*X[5]*X[5]	+8.14*X[3]*X[3]*X[4]*X[4]*X[5]	+7.88*X[0]*X[0]*X[0]*X[0]*X[2]*X[4]	+0.14*X[0]*X[0]*X[2]*X[2]*X[3]*X[5];

subject to Constraint_1:
	+4.68*X[0]	+6.71*X[1]	-7.13*X[2]	+5.38*X[3]	+1.26*X[4]	+7.91*X[5]	+0.3*X[0]*X[0]*X[5] >= 24.244;

subject to Constraint_2:
	+6.56*X[0]	+2.66*X[1]	-0.85*X[2]	+9.4*X[3]	+7.6*X[4]	+6.45*X[5]	+3.17*X[0]*X[0]*X[5]	+8.1*X[0]*X[1]*X[1]*X[5]	+7.31*X[0]*X[3]*X[5]*X[5]	+3.26*X[1]*X[2]*X[2]*X[3] >= 120.839;

subject to Constraint_3:
	+2.33*X[0]	+1.2*X[1]	+6.94*X[2]	+8.17*X[3]	+8.65*X[4]	+1.64*X[5]	-3.83*X[0]*X[0]*X[5]	+3.46*X[0]*X[1]*X[1]*X[5]	+9.56*X[0]*X[3]*X[5]*X[5]	+8.88*X[1]*X[2]*X[2]*X[3]	+6.25*X[0]*X[0]*X[2]*X[2]*X[2]	+2.54*X[0]*X[0]*X[5]*X[5]*X[5]	+5.11*X[3]*X[3]*X[4]*X[4]*X[5] >= 215.592;

subject to Constraint_4:
	-8.36*X[0]	+6.93*X[1]	+9.49*X[2]	+8.26*X[3]	+0.96*X[4]	+9.02*X[5] >= 35.05;

subject to Constraint_5:
	+5.71*X[0]	+6.53*X[1]	-8.19*X[2]	+7.74*X[3]	+1.49*X[4]	+5.31*X[5] >= 23.51;

