set VARS := 0..5;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.82;
let ub[0] := 2.25;
let lb[1] := 0.26;
let ub[1] := 2.03;
let lb[2] := 0.97;
let ub[2] := 2.24;
let lb[3] := 0.27;
let ub[3] := 2.76;
let lb[4] := 0.84;
let ub[4] := 2.4;
let lb[5] := 0.38;
let ub[5] := 2.34;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+5.21*X[0]	-8.06*X[1]	+8.98*X[2]	+3.86*X[3]	+8.89*X[4]	-1.1*X[5]	+8.12*X[0]*X[0]*X[0]*X[4]	+6.64*X[0]*X[0]*X[3]*X[3]	+0.05*X[0]*X[1]*X[1]*X[2]*X[4]	+8.58*X[1]*X[1]*X[2]*X[4]*X[4]	+7.01*X[0]*X[0]*X[0]*X[0]*X[3]*X[4];

subject to Constraint_1:
	-8.18*X[0]	+6.41*X[1]	+8.99*X[2]	+7.68*X[3]	+2.01*X[4]	+1.93*X[5]	+7.48*X[0]*X[0]*X[0]*X[4]	+2.04*X[0]*X[0]*X[3]*X[3] >= 81.588;

subject to Constraint_2:
	+7.64*X[0]	+2.21*X[1]	+7.33*X[2]	+5.94*X[3]	+5.32*X[4]	+6.89*X[5]	+0.38*X[0]*X[0]*X[0]*X[4]	+1.9*X[0]*X[0]*X[3]*X[3]	+8.15*X[0]*X[1]*X[1]*X[2]*X[4]	+7.86*X[1]*X[1]*X[2]*X[4]*X[4] >= 151.562;

subject to Constraint_3:
	+4.88*X[0]	+5.93*X[1]	+4.25*X[3] = 20.719;

subject to Constraint_4:
	+7.63*X[0]	-9.75*X[1]	-3.38*X[2]	+9.83*X[3]	+2.96*X[4]	+6.37*X[5] >= 23.474;

subject to Constraint_5:
	+7.2*X[0]	+2.08*X[1]	+1.17*X[2]	+3.61*X[3]	+4.38*X[4]	+1.56*X[5] >= 29.998;

subject to Constraint_6:
	+7.56*X[0]	+3.94*X[1]	+4.37*X[2]	+9.9*X[3]	+9.5*X[4]	+6.03*X[5] >= 61.719;

