set VARS := 0..5;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.02;
let ub[0] := 2.76;
let lb[1] := 0.77;
let ub[1] := 2.37;
let lb[2] := 0.6;
let ub[2] := 2.08;
let lb[3] := 0.71;
let ub[3] := 2.5;
let lb[4] := 0.03;
let ub[4] := 2.26;
let lb[5] := 0.28;
let ub[5] := 2.97;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+8.76*X[0]	+9.3*X[1]	+9.23*X[2]	+6.51*X[3]	+4.95*X[4]	+0.79*X[5]	+4.73*X[1]*X[2]*X[2]	+3.25*X[3]*X[4]*X[4]	+3.09*X[0]*X[1]*X[2]*X[2]	+1.81*X[0]*X[1]*X[3]*X[3]	-9.94*X[1]*X[1]*X[1]*X[3]	+8.23*X[1]*X[2]*X[2]*X[3]*X[4]	+8.06*X[0]*X[0]*X[1]*X[1]*X[1]*X[5]	+6.83*X[0]*X[1]*X[1]*X[1]*X[2]*X[5]	+8.33*X[0]*X[3]*X[4]*X[5]*X[5]*X[5];

subject to Constraint_1:
	+0.61*X[0]	+5.83*X[1]	+2.27*X[2]	+8.48*X[3]	+3.53*X[4]	+6.6*X[5]	+1.2*X[1]*X[2]*X[2]	+0.65*X[3]*X[4]*X[4] >= 46.171;

subject to Constraint_2:
	+2.53*X[0]	+9.54*X[1]	+5.24*X[2]	+1.23*X[3]	+1.52*X[4]	+9.9*X[5]	+3.67*X[1]*X[2]*X[2]	+2.33*X[3]*X[4]*X[4]	+9.43*X[0]*X[1]*X[2]*X[2]	+6.77*X[0]*X[1]*X[3]*X[3]	+2.73*X[1]*X[1]*X[1]*X[3] >= 152.534;

subject to Constraint_3:
	+4.04*X[0]	+6.93*X[1]	+5.84*X[2]	+1.66*X[3]	+8.41*X[4]	+9.96*X[5]	+1.99*X[1]*X[2]*X[2]	-0.75*X[3]*X[4]*X[4]	+0.16*X[0]*X[1]*X[2]*X[2]	+4.54*X[0]*X[1]*X[3]*X[3]	+0.26*X[1]*X[1]*X[1]*X[3]	+6.02*X[1]*X[2]*X[2]*X[3]*X[4] >= 115.784;

subject to Constraint_4:
	+8.15*X[0]	+5.54*X[1]	+3.95*X[2]	+8.41*X[3]	+7.51*X[4]	+0.11*X[5] = 47.595;

subject to Constraint_5:
	+8.19*X[0]	+3.85*X[1]	+4.2*X[2]	+8.18*X[3]	+5.44*X[4]	+7.19*X[5] >= 54.098;

subject to Constraint_6:
	+5.33*X[0]	+6.95*X[1]	+1.95*X[2]	+6.38*X[3]	+7.56*X[4]	+9.41*X[5] >= 55.121;

