set VARS := 0..5;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.13;
let ub[0] := 2.04;
let lb[1] := 0.2;
let ub[1] := 2.37;
let lb[2] := 0.61;
let ub[2] := 2.85;
let lb[3] := 0.22;
let ub[3] := 2.36;
let lb[4] := 0.25;
let ub[4] := 2.65;
let lb[5] := 0.28;
let ub[5] := 2.96;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+6.63*X[0]	+4.64*X[1]	+1.63*X[2]	+4.4*X[3]	-9.76*X[4]	+9.4*X[5]	+1.37*X[4]*X[4]	+3.38*X[2]*X[3]*X[3]	+7.38*X[0]*X[2]*X[2]*X[2]	+6.56*X[0]*X[1]*X[1]*X[1]*X[4]	+4.47*X[0]*X[0]*X[2]*X[2]*X[4]*X[4];

subject to Constraint_1:
	+5.43*X[0]	+9.26*X[1]	+8.51*X[2]	-8.19*X[3]	+8.78*X[4]	+9.39*X[5]	+1.63*X[4]*X[4] >= 53.318;

subject to Constraint_2:
	+6.05*X[0]	-3.5*X[1]	-9.43*X[2]	+9.01*X[3]	+9.5*X[4]	+3.74*X[5]	+7.01*X[4]*X[4]	-0.46*X[2]*X[3]*X[3] >= 30.624;

subject to Constraint_3:
	+7.81*X[0]	+1.47*X[1]	-4.21*X[2]	+1.58*X[3]	+3.6*X[4]	+1.56*X[5]	+6.36*X[4]*X[4]	+3.3*X[2]*X[3]*X[3]	+0.52*X[0]*X[2]*X[2]*X[2] >= 38.658;

subject to Constraint_4:
	+2.01*X[0]	+8.54*X[1]	+2.07*X[2]	+8.98*X[3]	+3.9*X[4]	+8.54*X[5]	+9.31*X[4]*X[4]	+7.26*X[2]*X[3]*X[3]	+8.49*X[0]*X[2]*X[2]*X[2]	+3.18*X[0]*X[1]*X[1]*X[1]*X[4] >= 146.596;

subject to Constraint_5:
	+1.6*X[0]	+5.19*X[1]	+6.07*X[2]	-7.15*X[3]	+3.78*X[4]	+2.53*X[5] = 19.262;

subject to Constraint_6:
	+1.93*X[0]	+2.32*X[1]	+1.49*X[2]	+7.98*X[3]	+0.64*X[4]	+9.26*X[5] = 33.876;

subject to Constraint_7:
	+5.22*X[0]	+1.29*X[1]	+4.51*X[2]	-9.97*X[3]	+8.32*X[4]	-7.41*X[5] = 2.322;

subject to Constraint_8:
	+1.75*X[0]	+4.9*X[1]	+3.71*X[2]	+1.73*X[3]	+8.89*X[4]	+7.3*X[5] >= 41.562;

