set VARS := 0..5;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.08;
let ub[0] := 2.61;
let lb[1] := 0.91;
let ub[1] := 2.31;
let lb[2] := 0.98;
let ub[2] := 2.5;
let lb[3] := 0.5;
let ub[3] := 2.9;
let lb[4] := 0.04;
let ub[4] := 2.99;
let lb[5] := 0.79;
let ub[5] := 2.35;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+4.01*X[0]	+1.71*X[1]	+7.75*X[2]	-7.56*X[3]	+9.5*X[4]	+1.55*X[5]	+7.21*X[1]*X[3]*X[4]	+8.81*X[0]*X[0]*X[2]*X[3]	+0.54*X[0]*X[1]*X[2]*X[2]*X[3]	+3.95*X[1]*X[1]*X[2]*X[3]*X[4]	+4.07*X[3]*X[3]*X[3]*X[4]*X[4]	+7.92*X[0]*X[0]*X[0]*X[0]*X[3]*X[5]	+6.82*X[0]*X[0]*X[2]*X[3]*X[3]*X[4]	+8.56*X[0]*X[2]*X[4]*X[4]*X[4]*X[4]	+8.84*X[3]*X[4]*X[4]*X[4]*X[4]*X[4];

subject to Constraint_1:
	-9.59*X[0]	-0.63*X[1]	+0.48*X[2]	-7.47*X[3]	+7.56*X[4]	+5.25*X[5]	+9.59*X[1]*X[3]*X[4] >= 33.685;

subject to Constraint_2:
	+3.87*X[0]	+7.7*X[1]	+0.2*X[2]	+6.25*X[3]	+4.24*X[4]	+8.65*X[5]	+1.44*X[1]*X[3]*X[4]	+1.8*X[0]*X[0]*X[2]*X[3] >= 64.182;

subject to Constraint_3:
	+2.29*X[0]	+5.62*X[1]	+7.9*X[2]	+3.86*X[3]	+8.31*X[4]	+4.49*X[5]	+0.03*X[1]*X[3]*X[4]	+6.72*X[0]*X[0]*X[2]*X[3]	+7.35*X[0]*X[1]*X[2]*X[2]*X[3]	+2.96*X[1]*X[1]*X[2]*X[3]*X[4]	+8.35*X[3]*X[3]*X[3]*X[4]*X[4] >= 298.62;

subject to Constraint_4:
	+0.33*X[0]	+3.44*X[1]	+4.69*X[2]	-2.56*X[3]	+1.77*X[4]	+9.14*X[5] = 26.822;

subject to Constraint_5:
	+8.47*X[0]	+0.74*X[1]	+7.49*X[2]	+9.1*X[3]	+1.62*X[4]	+4.65*X[5] = 50.841;

subject to Constraint_6:
	+0.82*X[0]	+3.41*X[1]	+4.01*X[2]	+3.43*X[3]	+8.04*X[4]	+9.23*X[5] = 46.073;

subject to Constraint_7:
	+0.81*X[0]	+5.8*X[1]	+7.41*X[2]	+1.3*X[3]	+4.66*X[4]	+7.25*X[5] >= 43.973;

subject to Constraint_8:
	+2.79*X[0]	+9.02*X[1]	+0.93*X[2]	+6.49*X[3]	+1.35*X[4]	+9.8*X[5] >= 48.357;

