set VARS := 0..4;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.24;
let ub[0] := 2.77;
let lb[1] := 0.54;
let ub[1] := 2.67;
let lb[2] := 0.13;
let ub[2] := 3;
let lb[3] := 0.78;
let ub[3] := 2.28;
let lb[4] := 0.8;
let ub[4] := 2.94;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+6.34*X[0]	+4.08*X[1]	-7.98*X[2]	-9.18*X[3]	+8.83*X[4]	+6.17*X[0]*X[3]*X[4]	+8.52*X[0]*X[1]*X[1]*X[4]	+0.39*X[0]*X[0]*X[4]*X[4]*X[4]	+3.94*X[0]*X[2]*X[2]*X[2]*X[2]	+3.5*X[2]*X[3]*X[3]*X[3]*X[4]	+5.93*X[0]*X[0]*X[0]*X[1]*X[2]*X[3]	+5.72*X[1]*X[1]*X[2]*X[2]*X[3]*X[3]*X[4];

subject to Constraint_1:
	+7.63*X[0]	+8.55*X[1]	+3.18*X[2]	+4.79*X[3]	+4.66*X[4]	+2.67*X[0]*X[3]*X[4] >= 57.722;

subject to Constraint_2:
	+6.55*X[0]	+6.23*X[1]	+8.26*X[2]	+8.32*X[3]	+9.54*X[4]	+4.19*X[0]*X[1]*X[1]*X[4]	-1.92*X[0]*X[3]*X[4] >= 85.463;

subject to Constraint_3:
	+6.01*X[0]	-6.14*X[1]	+2.85*X[2]	+6.99*X[3]	+8.02*X[4]	+8.94*X[0]*X[3]*X[4]	+9.86*X[0]*X[1]*X[1]*X[4]	-2.4*X[0]*X[0]*X[4]*X[4]*X[4]	+9.88*X[0]*X[2]*X[2]*X[2]*X[2]	+2.12*X[2]*X[3]*X[3]*X[3]*X[4] >= 215.192;

subject to Constraint_4:
	+1.66*X[0]	+0.53*X[1]	+8.85*X[2]	+1.9*X[3]	+3.02*X[4] >= 25.754;

subject to Constraint_5:
	+6.36*X[0]	+9.12*X[1]	+7.05*X[2]	+2.28*X[3]	+0.66*X[4] >= 39.965;

