set VARS := 0..4;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.97;
let ub[0] := 2.81;
let lb[1] := 0.86;
let ub[1] := 2.13;
let lb[2] := 0.16;
let ub[2] := 2.53;
let lb[3] := 0.6;
let ub[3] := 2.55;
let lb[4] := 0.71;
let ub[4] := 2.2;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+3.64*X[0]	+8.26*X[1]	+2.67*X[2]	-0.57*X[3]	+4.36*X[4]	+9.27*X[2]*X[3]*X[3]*X[3]	+7.1*X[0]*X[0]*X[1]*X[3]*X[4]	-9.91*X[0]*X[0]*X[2]*X[2]*X[4]	+0.87*X[0]*X[0]*X[0]*X[0]*X[1]*X[3]*X[4]	+3.11*X[0]*X[0]*X[0]*X[1]*X[2]*X[3]*X[3]	+8.41*X[0]*X[0]*X[1]*X[2]*X[4]*X[4]*X[4]	+7.61*X[0]*X[0]*X[1]*X[3]*X[3]*X[3]*X[4]	+4.85*X[1]*X[2]*X[2]*X[2]*X[2]*X[2]*X[2];

subject to Constraint_1:
	+2*X[0]	+0.37*X[1]	+9.05*X[2]	+7.76*X[3]	-4.77*X[4]	+3.75*X[2]*X[3]*X[3]*X[3] >= 41.493;

subject to Constraint_2:
	+4.22*X[0]	+2.02*X[1]	+3.11*X[2]	+6.38*X[3]	+9.02*X[4]	+4.75*X[2]*X[3]*X[3]*X[3]	-9.76*X[0]*X[0]*X[1]*X[3]*X[4]	+6.59*X[0]*X[0]*X[2]*X[2]*X[4] >= 5.83;

subject to Constraint_3:
	+5.73*X[1]	-6.97*X[3] = -2.411;

subject to Constraint_4:
	+1.24*X[0]	+9.37*X[1]	+4.63*X[2]	+9.66*X[3]	+7.22*X[4] >= 48.299;

subject to Constraint_5:
	+7.17*X[0]	+5.79*X[1]	+9.19*X[2]	+2.35*X[3]	+0.88*X[4] >= 39.55;

subject to Constraint_6:
	+6.72*X[0]	+0.95*X[1]	+0.07*X[2]	+5.89*X[3]	-5.93*X[4] >= 14.864;

