set VARS := 0..4;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.24;
let ub[0] := 2.07;
let lb[1] := 0.16;
let ub[1] := 2.92;
let lb[2] := 0.78;
let ub[2] := 2.58;
let lb[3] := 0.4;
let ub[3] := 2.53;
let lb[4] := 0.1;
let ub[4] := 2.72;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	-7.68*X[0]	+6.73*X[1]	+4.6*X[2]	-9.04*X[3]	+5.15*X[4]	+9.94*X[1]*X[2]	+7.68*X[0]*X[0]*X[3]*X[3]*X[4]	+1.54*X[0]*X[0]*X[4]*X[4]*X[4]	+3.76*X[0]*X[0]*X[0]*X[0]*X[0]*X[3]	-1.94*X[0]*X[0]*X[0]*X[1]*X[1]*X[2]	+2.36*X[0]*X[0]*X[1]*X[3]*X[4]*X[4]	+5.46*X[2]*X[2]*X[4]*X[4]*X[4]*X[4]	-3.91*X[1]*X[3]*X[3]*X[4]*X[4]*X[4]*X[4];

subject to Constraint_1:
	+9.81*X[0]	+3.7*X[1]	+8.14*X[2]	+6.19*X[3]	+1.69*X[4]	+7.74*X[1]*X[2] >= 62.18;

subject to Constraint_2:
	+1.03*X[0]	+5.2*X[1]	+5.07*X[2]	+4.83*X[3]	+2.54*X[4]	+7.25*X[1]*X[2] >= 47.13;

subject to Constraint_3:
	+9.35*X[0]	+6.83*X[1]	+4.87*X[2]	+0.54*X[3]	+4.9*X[4]	+6.88*X[1]*X[2] >= 54.999;

subject to Constraint_4:
	-4.01*X[0]	+10*X[1]	+5.29*X[2]	+9.39*X[3]	+0.1*X[4]	-0.47*X[1]*X[2]	+5.77*X[0]*X[0]*X[3]*X[3]*X[4]	+6.35*X[0]*X[0]*X[4]*X[4]*X[4] >= 79.377;

subject to Constraint_5:
	+6.93*X[0]	+5.01*X[1]	+7.11*X[2]	+7.11*X[3]	+1.13*X[4] = 39.674;

subject to Constraint_6:
	+1.99*X[0]	+7.54*X[1]	-4.06*X[2]	+0.16*X[3]	+7.61*X[4] = 18.054;

subject to Constraint_7:
	+3*X[0]	+5.02*X[1]	-8.32*X[2]	+1.39*X[3]	+1.85*X[4] >= 1.863;

