set VARS := 0..15;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.75;
let ub[0] := 2.39;
let lb[1] := 0.65;
let ub[1] := 2.17;
let lb[2] := 0.91;
let ub[2] := 2.61;
let lb[3] := 0.9;
let ub[3] := 2.74;
let lb[4] := 0.93;
let ub[4] := 2.12;
let lb[5] := 0.26;
let ub[5] := 2.11;
let lb[6] := 0.09;
let ub[6] := 2.9;
let lb[7] := 0.93;
let ub[7] := 2.69;
let lb[8] := 0.66;
let ub[8] := 2.12;
let lb[9] := 0.48;
let ub[9] := 2.9;
let lb[10] := 0.78;
let ub[10] := 2.54;
let lb[11] := 0.11;
let ub[11] := 2.97;
let lb[12] := 0.91;
let ub[12] := 2.49;
let lb[13] := 0.96;
let ub[13] := 2.17;
let lb[14] := 0.91;
let ub[14] := 2.29;
let lb[15] := 0.89;
let ub[15] := 2.36;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+3.07*X[0]	+0.82*X[1]	+4.19*X[2]	+2.5*X[3]	+9.92*X[4]	+9.71*X[5]	+3.36*X[6]	+8.49*X[7]	+2.03*X[8]	+3.56*X[9]	+0.74*X[10]	-9.72*X[11]	-5.49*X[12]	+6.01*X[13]	+1.15*X[14]	+4.51*X[15]	+8.56*X[0]*X[11]	+6.9*X[10]*X[11]	+7.02*X[0]*X[10]*X[10]	+3.7*X[1]*X[8]*X[10]	+0.59*X[2]*X[4]*X[7]	+7.55*X[2]*X[8]*X[9]	-8.16*X[3]*X[9]*X[10]	+2.69*X[4]*X[4]*X[6]	+7.27*X[4]*X[10]*X[11]	-2.38*X[5]*X[8]*X[9];

subject to Constraint_1:
	+6.02*X[0]	+9.14*X[1]	+4.71*X[2]	+5.9*X[3]	+6.68*X[4]	+5.93*X[5]	-3.98*X[6]	+9.15*X[7]	+7.98*X[8]	+3.06*X[9]	+4.54*X[10]	-1.82*X[11]	+6.28*X[12]	+0.67*X[13]	+0.17*X[14]	+2.34*X[15]	+5.57*X[0]*X[11]	+8.18*X[10]*X[11] >= 140.367;

subject to Constraint_2:
	+6.3*X[0]	+0.31*X[1]	+0.44*X[2]	+4.53*X[3]	+7.5*X[4]	+4.12*X[5]	+5.35*X[6]	+4.47*X[7]	+4.15*X[8]	+8.02*X[9]	+7.27*X[10]	+6.8*X[11]	+1.16*X[12]	+1.42*X[13]	+3.89*X[14]	+4.99*X[15]	+8.34*X[0]*X[11]	+3.32*X[10]*X[11]	+2.66*X[0]*X[10]*X[10]	+9.54*X[1]*X[8]*X[10]	+0.48*X[2]*X[4]*X[7]	+0.08*X[2]*X[8]*X[9]	+4.04*X[3]*X[9]*X[10]	+6*X[4]*X[4]*X[6]	+0.82*X[4]*X[10]*X[11]	+5.01*X[5]*X[8]*X[9] >= 244.637;

subject to Constraint_3:
	+3.22*X[0]	+5.79*X[1]	+7.74*X[2]	+2.13*X[3]	+7.94*X[4]	-2.21*X[5]	+6.3*X[6]	+8.04*X[7]	+8.98*X[8]	+0.74*X[9]	+7.16*X[10]	+5.04*X[11]	+6.89*X[12]	-7.71*X[13]	+6.89*X[14]	+8.55*X[15]	+1.83*X[0]*X[11]	+0.63*X[10]*X[11] >= 128.159;

subject to Constraint_4:
	+0.51*X[0]	-7.6*X[1]	+5.03*X[2]	+4.79*X[3]	+1.78*X[4]	+5.76*X[5]	+7.07*X[6]	+5.32*X[7]	-6.66*X[8]	+7.53*X[9]	+1.17*X[10]	+2.06*X[11]	+7.84*X[12]	+3.26*X[13]	+1.9*X[14]	+6.32*X[15]	+0.09*X[0]*X[11]	+7.69*X[10]*X[11]	+3.58*X[0]*X[10]*X[10]	+9.49*X[1]*X[8]*X[10]	+6.82*X[2]*X[4]*X[7]	+4.08*X[2]*X[8]*X[9]	+1.66*X[3]*X[9]*X[10]	+2.31*X[4]*X[4]*X[6]	+4.49*X[4]*X[10]*X[11]	+0.75*X[5]*X[8]*X[9] >= 230.056;

subject to Constraint_5:
	+6.02*X[0]	+7*X[1]	+4.2*X[2]	+5.65*X[3]	-7.26*X[4]	+7.68*X[5]	+6.93*X[6]	+6.86*X[7]	+1.22*X[8]	+0.43*X[9]	+1.73*X[10]	+5.09*X[11]	-0.52*X[12]	+3.13*X[13]	+4.69*X[14]	+4.75*X[15]	-5.84*X[10]*X[11]	-6.23*X[0]*X[11] >= 60.18;

subject to Constraint_6:
	+7.28*X[0]	+1.94*X[1]	+4.73*X[2]	+6.75*X[3]	+2.67*X[4]	+0.47*X[5]	+8.14*X[6]	+0.24*X[7]	+3*X[8]	+8.26*X[9]	+7.08*X[10]	+8.25*X[11]	+0.43*X[12]	+3.48*X[13]	+5.1*X[14]	+6.02*X[15] = 118.714;

subject to Constraint_7:
	+4.88*X[0]	+9.15*X[1]	+3.38*X[2]	+4.21*X[3]	+0.57*X[4]	+7.12*X[5]	+7.72*X[6]	+3.4*X[7]	+6.13*X[8]	+9.77*X[9]	+3.16*X[10]	+2.24*X[11]	+5.12*X[12]	+4.21*X[13]	+5.05*X[14]	+1.24*X[15] = 120.291;

subject to Constraint_8:
	+6.4*X[0]	+6.93*X[1]	+2.58*X[2]	+6.56*X[3]	+2.94*X[4]	+5.72*X[5]	+0.22*X[6]	+5.61*X[7]	-9.45*X[8]	+9.76*X[9]	+6.66*X[10]	+9.57*X[11]	+3.38*X[12]	+3.2*X[13]	+5.47*X[14]	+9.29*X[15] = 121.799;

subject to Constraint_9:
	+7.99*X[0]	+2.24*X[1]	+4.39*X[2]	+4.22*X[3]	+4.87*X[4]	+6.95*X[5]	+3.49*X[6]	+5.66*X[7]	+9.04*X[8]	+0.95*X[9]	+5.26*X[10]	-5.55*X[11]	+2.53*X[12]	+4.34*X[13]	+4.06*X[14]	+1.82*X[15] = 97.136;

subject to Constraint_10:
	+5.32*X[0]	+3.81*X[1]	+2.08*X[2]	+1.62*X[3]	+0.17*X[4]	+7.74*X[5]	-0.85*X[6]	+8.5*X[7]	+6.88*X[8]	+3.34*X[9]	+1.72*X[10]	-9.94*X[11]	+1*X[12]	+1.22*X[13]	+1.08*X[14]	+3.31*X[15] >= 57.351;

subject to Constraint_11:
	+3.75*X[0]	+5.93*X[1]	+4.11*X[2]	+7.26*X[3]	+1.17*X[4]	+6.44*X[5]	+7.63*X[6]	+1.19*X[7]	+4.89*X[8]	+1.52*X[9]	+9.42*X[10]	+4.16*X[11]	+9.79*X[12]	+7.32*X[13]	+5.14*X[14]	+9.81*X[15] >= 141.346;

subject to Constraint_12:
	+4.01*X[0]	+3.34*X[1]	+8.36*X[2]	-8.94*X[3]	+6.06*X[4]	+1.51*X[5]	+9.47*X[6]	+4.23*X[7]	+5.05*X[8]	+0.52*X[9]	+5.51*X[10]	+7.94*X[11]	+4.42*X[12]	+9.48*X[13]	+6.85*X[14]	+5.21*X[15] >= 113.342;

