set VARS := 0..11;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.22;
let ub[0] := 2.75;
let lb[1] := 0.09;
let ub[1] := 2.73;
let lb[2] := 0.03;
let ub[2] := 2.27;
let lb[3] := 0.27;
let ub[3] := 2.11;
let lb[4] := 0.62;
let ub[4] := 2.85;
let lb[5] := 0.06;
let ub[5] := 2.65;
let lb[6] := 0.95;
let ub[6] := 2.05;
let lb[7] := 0.84;
let ub[7] := 2.42;
let lb[8] := 0.65;
let ub[8] := 2.98;
let lb[9] := 0.75;
let ub[9] := 2.07;
let lb[10] := 0.04;
let ub[10] := 2.38;
let lb[11] := 0.08;
let ub[11] := 2.76;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+1.44*X[0]	+2.13*X[1]	+4.67*X[2]	+8.67*X[3]	+4.54*X[4]	+3.43*X[5]	+6.09*X[6]	-4.67*X[7]	-9.18*X[8]	+9.59*X[9]	-6.04*X[10]	-5.35*X[11]	+3.04*X[7]*X[7]	+6.82*X[9]*X[10]	+2.97*X[0]*X[2]*X[11]	+0.14*X[3]*X[6]*X[6]	+9.63*X[6]*X[11]*X[11]	+6.14*X[0]*X[0]*X[1]*X[3]	+1.11*X[0]*X[0]*X[3]*X[5]	+2.71*X[0]*X[2]*X[6]*X[7]	-3.47*X[0]*X[3]*X[5]*X[11]	+0.13*X[0]*X[4]*X[5]*X[6]	+1.26*X[1]*X[5]*X[6]*X[9]	+8.42*X[1]*X[8]*X[8]*X[10]	+6.53*X[2]*X[2]*X[4]*X[11]	+0.93*X[4]*X[7]*X[7]*X[11]	+2.85*X[5]*X[6]*X[7]*X[9]	+2.91*X[5]*X[7]*X[7]*X[8]	+5.91*X[5]*X[9]*X[9]*X[9]	+9.52*X[7]*X[10]*X[10]*X[10];

subject to Constraint_1:
	+8.49*X[0]	+1.5*X[1]	+5.23*X[2]	+1.29*X[3]	+7.92*X[4]	+6.54*X[5]	+7.92*X[6]	-2.99*X[7]	+8.67*X[8]	+7.13*X[9]	+8.66*X[10]	+5.5*X[11]	+7.4*X[7]*X[7]	+0.8*X[9]*X[10] >= 116.985;

subject to Constraint_2:
	+3.43*X[0]	+6.58*X[1]	+8.47*X[2]	+6.84*X[3]	+6.66*X[4]	+2.28*X[5]	+3.18*X[6]	+9.65*X[7]	+1.05*X[8]	+5.85*X[9]	+0.32*X[10]	+3.27*X[11]	+8.75*X[7]*X[7]	+7.97*X[9]*X[10]	-7.88*X[0]*X[2]*X[11]	+7.24*X[3]*X[6]*X[6]	-3.73*X[6]*X[11]*X[11] >= 108.42;

subject to Constraint_3:
	+8.16*X[0]	+6.08*X[1]	+3.64*X[2]	+5.41*X[3]	+7.52*X[4]	+1.63*X[5]	+5.4*X[6]	+3.54*X[7]	+2.61*X[8]	+3.23*X[9]	+5.94*X[10]	+4.33*X[11]	+0.73*X[7]*X[7]	+8.33*X[9]*X[10]	+9.89*X[0]*X[2]*X[11]	-7.86*X[3]*X[6]*X[6]	+6.28*X[6]*X[11]*X[11]	+1.15*X[0]*X[0]*X[1]*X[3]	+5.23*X[0]*X[0]*X[3]*X[5]	+6.66*X[0]*X[2]*X[6]*X[7]	+8.53*X[0]*X[3]*X[5]*X[11]	+1.91*X[0]*X[4]*X[5]*X[6]	+6.62*X[1]*X[5]*X[6]*X[9]	+5.65*X[1]*X[8]*X[8]*X[10]	+0.5*X[2]*X[2]*X[4]*X[11]	+7.37*X[4]*X[7]*X[7]*X[11]	+9.89*X[5]*X[6]*X[7]*X[9]	+3.24*X[5]*X[7]*X[7]*X[8]	+9.2*X[5]*X[9]*X[9]*X[9]	-2.56*X[7]*X[10]*X[10]*X[10] >= 414.117;

subject to Constraint_4:
	+2.69*X[0]	+8.6*X[1]	+6.62*X[2]	+4.67*X[3]	+3.44*X[4]	+4.52*X[5]	+4.45*X[6]	+4.49*X[7]	+0.32*X[8]	+3.87*X[9]	+3*X[10]	+4.12*X[11]	+0.69*X[7]*X[7]	+6.27*X[9]*X[10] >= 83.426;

subject to Constraint_5:
	+1.15*X[0]	+2.82*X[2]	+7.06*X[3]	+1*X[6]	+6.97*X[7]	+4.83*X[8] = 34.98;

subject to Constraint_6:
	+8.72*X[1]	+1.13*X[4]	+2.47*X[5]	+0.24*X[6]	+9.5*X[9]	-0.82*X[10] = 30.365;

subject to Constraint_7:
	+8.79*X[0]	+0.86*X[1]	-3.74*X[3]	+7.07*X[7]	-0.16*X[9]	-5.82*X[10] = 14.071;

subject to Constraint_8:
	+7.52*X[0]	-6.1*X[1]	+9.24*X[2]	-4.63*X[3]	+8.62*X[4]	+5.57*X[5]	+1.56*X[6]	+5.7*X[7]	+3.4*X[8]	-4.16*X[9]	+4.38*X[10]	+3.22*X[11] >= 51.994;

subject to Constraint_9:
	+7.95*X[0]	+3.72*X[1]	+7.07*X[2]	+3.8*X[3]	+7.8*X[4]	+0.88*X[5]	+4.64*X[6]	+2.98*X[7]	+8.9*X[8]	+2.94*X[9]	+4.54*X[10]	+3.03*X[11] >= 86.341;

