set VARS := 0..11;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.35;
let ub[0] := 2.16;
let lb[1] := 0.67;
let ub[1] := 2.93;
let lb[2] := 0.43;
let ub[2] := 2.79;
let lb[3] := 0.78;
let ub[3] := 2.03;
let lb[4] := 0.75;
let ub[4] := 2.06;
let lb[5] := 0.66;
let ub[5] := 2.9;
let lb[6] := 0.74;
let ub[6] := 2.04;
let lb[7] := 0.68;
let ub[7] := 2.39;
let lb[8] := 0.42;
let ub[8] := 2.33;
let lb[9] := 0.67;
let ub[9] := 2.52;
let lb[10] := 0.55;
let ub[10] := 2.59;
let lb[11] := 0.04;
let ub[11] := 2.41;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+2.71*X[0]	+2.76*X[1]	+3.69*X[2]	+9.76*X[3]	+1.99*X[4]	+6.95*X[5]	+2.37*X[6]	+7.32*X[7]	-1.76*X[8]	+3.84*X[9]	+4.12*X[10]	+6.27*X[11]	+3.83*X[3]*X[3]	+4*X[0]*X[0]*X[2]	+4.12*X[1]*X[4]*X[6]	+4.12*X[2]*X[4]*X[4]	+2*X[0]*X[0]*X[1]*X[11]	+8.71*X[0]*X[0]*X[8]*X[8]	+6.42*X[0]*X[0]*X[9]*X[10]	+0.41*X[0]*X[2]*X[9]*X[10]	+1.06*X[0]*X[3]*X[4]*X[4]	+0.43*X[1]*X[1]*X[8]*X[8]	+8.46*X[2]*X[5]*X[9]*X[11]	+7.88*X[2]*X[10]*X[10]*X[10]	+6.95*X[3]*X[8]*X[8]*X[9]	+4.65*X[3]*X[8]*X[9]*X[11]	+6.93*X[4]*X[6]*X[8]*X[9]	+4.83*X[5]*X[5]*X[6]*X[8]	-8.22*X[6]*X[7]*X[8]*X[11]	-2.78*X[9]*X[10]*X[10]*X[10];

subject to Constraint_1:
	+0.05*X[0]	+1.8*X[1]	+5.95*X[2]	+1.54*X[3]	+8.39*X[4]	+4.93*X[5]	+8.48*X[6]	+1.87*X[7]	+4.05*X[8]	+0.98*X[9]	+5.88*X[10]	+8.13*X[11]	+7.05*X[3]*X[3] >= 90.507;

subject to Constraint_2:
	+3.29*X[0]	+7.03*X[1]	-9.73*X[2]	+7.05*X[3]	+4.64*X[4]	+8.23*X[5]	+5.28*X[6]	+9.21*X[7]	+9.62*X[8]	+4.64*X[9]	+5.63*X[10]	-1.24*X[11]	+8.27*X[3]*X[3]	+2.96*X[0]*X[0]*X[2]	+8.12*X[1]*X[4]*X[6]	+1.71*X[2]*X[4]*X[4] >= 139.427;

subject to Constraint_3:
	+0.96*X[0]	+5.4*X[1]	+2.07*X[2]	+9.64*X[3]	+4.54*X[4]	+4.86*X[5]	+5.56*X[6]	+5.3*X[7]	+9.71*X[8]	+1.39*X[9]	+3.42*X[10]	+2.3*X[11]	+9.62*X[3]*X[3]	+9.87*X[0]*X[0]*X[2]	+6.51*X[1]*X[4]*X[6]	+0.89*X[2]*X[4]*X[4]	-9.81*X[0]*X[0]*X[1]*X[11]	+8.95*X[0]*X[0]*X[8]*X[8]	+2.21*X[0]*X[0]*X[9]*X[10]	+2.57*X[0]*X[2]*X[9]*X[10]	+9.33*X[0]*X[3]*X[4]*X[4]	+1.26*X[1]*X[1]*X[8]*X[8]	+6.17*X[2]*X[5]*X[9]*X[11]	+5.86*X[2]*X[10]*X[10]*X[10]	+3.09*X[3]*X[8]*X[8]*X[9]	+4.87*X[3]*X[8]*X[9]*X[11]	+5.36*X[4]*X[6]*X[8]*X[9]	+3.38*X[5]*X[5]*X[6]*X[8]	+5.5*X[6]*X[7]*X[8]*X[11]	+5.95*X[9]*X[10]*X[10]*X[10] >= 409.129;

subject to Constraint_4:
	+1.88*X[0]	+3.48*X[1]	+1.72*X[2]	+8.33*X[3]	+4.63*X[4]	+8.1*X[5]	+8.6*X[6]	+9.55*X[7]	+7.33*X[8]	+2.59*X[9]	+1.42*X[10]	+4.14*X[11]	+5.18*X[3]*X[3] >= 102.369;

subject to Constraint_5:
	+8.3*X[0]	+4.53*X[1]	+6.94*X[2]	+3.32*X[3]	+6.86*X[4]	+0.52*X[5]	+4.7*X[6]	+2.34*X[7]	+9.68*X[8]	+4.59*X[9]	-8.73*X[10]	+1.28*X[11] = 63.59;

subject to Constraint_6:
	-5.02*X[0]	+1.2*X[1]	+9.13*X[2]	+3.92*X[3]	+6.81*X[4]	+1.73*X[5]	+7.88*X[6]	+7.59*X[7]	+0.42*X[8]	+9.15*X[9]	+6.31*X[10]	+9.16*X[11] = 87.618;

subject to Constraint_7:
	+0.84*X[0]	+9.91*X[1]	+0.02*X[2]	+8.4*X[3]	+5.31*X[4]	+6.13*X[5]	+0.33*X[6]	+8.88*X[7]	+0.68*X[8]	+7.55*X[9]	+2.87*X[10]	+8.07*X[11] = 90.557;

subject to Constraint_8:
	+6.44*X[0]	+3.03*X[1]	+4.61*X[2]	+2.3*X[3]	+7.38*X[4]	+2.58*X[5]	+7.12*X[6]	+7.89*X[7]	+4.09*X[8]	+6.55*X[9]	+6.63*X[10]	+5.21*X[11] >= 94.021;

subject to Constraint_9:
	+2.26*X[0]	+0.21*X[1]	+5.4*X[2]	+2.72*X[3]	+0.43*X[4]	+3.43*X[5]	+2.14*X[6]	+0.68*X[7]	-1.24*X[8]	+2.92*X[9]	+2.98*X[10]	+9.02*X[11] >= 45.138;

