set VARS := 0..11;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.06;
let ub[0] := 2.92;
let lb[1] := 0.45;
let ub[1] := 2.96;
let lb[2] := 0.62;
let ub[2] := 2.07;
let lb[3] := 0.94;
let ub[3] := 2.65;
let lb[4] := 0.31;
let ub[4] := 2.14;
let lb[5] := 0.31;
let ub[5] := 2.51;
let lb[6] := 0.44;
let ub[6] := 2.65;
let lb[7] := 0.93;
let ub[7] := 2.03;
let lb[8] := 0.43;
let ub[8] := 2.05;
let lb[9] := 0.54;
let ub[9] := 2.02;
let lb[10] := 0.07;
let ub[10] := 2.7;
let lb[11] := 0.17;
let ub[11] := 2.07;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	-6.4*X[0]	+7.67*X[1]	+6.38*X[2]	+6.02*X[3]	+4.83*X[4]	+2.6*X[5]	+3.44*X[6]	+7.97*X[7]	+9.2*X[8]	-5.28*X[9]	-9.76*X[10]	-4.11*X[11]	-0.92*X[4]*X[5]	+3.94*X[0]*X[0]*X[1]	-5.73*X[1]*X[1]*X[6]	+0.07*X[2]*X[7]*X[9]	+5.69*X[5]*X[8]*X[8]	+4.9*X[0]*X[0]*X[0]*X[2]	+5.76*X[1]*X[1]*X[6]*X[7]	+8.91*X[1]*X[5]*X[6]*X[9]	+3.95*X[3]*X[3]*X[4]*X[9];

subject to Constraint_1:
	+2.62*X[0]	+2.72*X[1]	-7.21*X[2]	+8.88*X[3]	+9.48*X[4]	+6.15*X[5]	+3.54*X[6]	+8.09*X[7]	+3.07*X[8]	+8.12*X[9]	+9.18*X[10]	+0.35*X[11]	+5.55*X[4]*X[5] >= 89.403;

subject to Constraint_2:
	+7.72*X[0]	+8.37*X[1]	+5.88*X[2]	+1.43*X[3]	+7.04*X[4]	+0.17*X[5]	+6.87*X[6]	+7.41*X[7]	+7.43*X[8]	-2.67*X[9]	+2.78*X[10]	+5.72*X[11]	+1.83*X[4]*X[5]	+9.03*X[0]*X[0]*X[1]	+5.36*X[1]*X[1]*X[6]	+1.45*X[2]*X[7]*X[9]	-0.98*X[5]*X[8]*X[8] >= 145.731;

subject to Constraint_3:
	+1.4*X[0]	+4.87*X[1]	+3.84*X[2]	+0.5*X[3]	+5.83*X[4]	+4.12*X[5]	-2.09*X[6]	+7.75*X[7]	+7.73*X[8]	-0.14*X[9]	+3.34*X[10]	+9.23*X[11]	+6.24*X[4]*X[5]	+5.65*X[0]*X[0]*X[1]	+0.69*X[1]*X[1]*X[6]	+6.64*X[2]*X[7]*X[9]	+3.22*X[5]*X[8]*X[8]	+0.09*X[0]*X[0]*X[0]*X[2]	-6.96*X[1]*X[1]*X[6]*X[7]	+7.8*X[1]*X[5]*X[6]*X[9]	+0.54*X[3]*X[3]*X[4]*X[9] >= 115.124;

subject to Constraint_4:
	+3.09*X[0]	+4.98*X[1]	-7.37*X[2]	+3.11*X[3]	+0.8*X[4]	+4.57*X[5]	+8.06*X[6]	+8.62*X[7]	+6.89*X[8]	+2.52*X[9]	+7.34*X[10]	+9.31*X[11]	+8.27*X[4]*X[5] >= 88.045;

subject to Constraint_5:
	+6.13*X[0]	+9.9*X[1]	+6.3*X[2]	+3.05*X[4]	+9.96*X[9]	-2.75*X[11] = 47.892;

subject to Constraint_6:
	+5.17*X[1]	+8.13*X[3]	+8.97*X[4]	+0.57*X[6]	+1.31*X[8]	+9.33*X[11] = 47.351;

subject to Constraint_7:
	+2.94*X[2]	+3.07*X[3]	+9.88*X[4]	+9.06*X[7]	+6.31*X[9]	+3.56*X[10] = 47.984;

subject to Constraint_8:
	+0.21*X[0]	+3.49*X[3]	+3.57*X[5]	-9.66*X[8]	+3.75*X[10]	+9.19*X[11] = 15.119;

subject to Constraint_9:
	+8.86*X[0]	+1.27*X[1]	+4.98*X[5]	+9.71*X[6]	+5.93*X[10]	+5.6*X[11] = 51.876;

subject to Constraint_10:
	+7.84*X[0]	+3.6*X[1]	+3.9*X[2]	+6.09*X[8]	+9.76*X[9]	+6.14*X[11] = 49.986;

subject to Constraint_11:
	+2.61*X[0]	+6.84*X[1]	+2.41*X[2]	+1.87*X[3]	+7.69*X[4]	+4.87*X[5]	+6.31*X[6]	+1.84*X[7]	+6.89*X[8]	+6.03*X[9]	+2.04*X[10]	+2.36*X[11] >= 72.639;

subject to Constraint_12:
	+9.28*X[0]	+1.42*X[1]	+1.25*X[2]	+3.92*X[3]	+5.02*X[4]	+3.53*X[5]	+3.39*X[6]	+7.75*X[7]	+0.09*X[8]	+1.52*X[9]	+6.64*X[10]	-4.54*X[11] >= 58.969;

