set VARS := 0..11;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.51;
let ub[0] := 2.87;
let lb[1] := 0.25;
let ub[1] := 2.18;
let lb[2] := 0.31;
let ub[2] := 2.41;
let lb[3] := 0.56;
let ub[3] := 2.21;
let lb[4] := 0.1;
let ub[4] := 2.07;
let lb[5] := 0.41;
let ub[5] := 2.49;
let lb[6] := 0.94;
let ub[6] := 2.97;
let lb[7] := 0.07;
let ub[7] := 2.79;
let lb[8] := 0.32;
let ub[8] := 2.74;
let lb[9] := 0.71;
let ub[9] := 2.79;
let lb[10] := 0.98;
let ub[10] := 2.29;
let lb[11] := 0.82;
let ub[11] := 2.12;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	-4.56*X[0]	+4.96*X[1]	+7.47*X[2]	+5.32*X[3]	+5.93*X[4]	-3.25*X[5]	+1.65*X[6]	+0.71*X[7]	+2.23*X[8]	+4.75*X[9]	+9.2*X[10]	+2.46*X[11]	+5.35*X[4]*X[8]	+9.11*X[11]*X[11]	+0.29*X[0]*X[11]*X[11]	-0.97*X[1]*X[6]*X[7]	+8.42*X[2]*X[5]*X[5]	+9.41*X[3]*X[4]*X[11]	+8.29*X[0]*X[0]*X[7]*X[11]	+7.81*X[0]*X[1]*X[4]*X[7]	+7.5*X[0]*X[2]*X[9]*X[9]	+7.94*X[0]*X[2]*X[9]*X[11]	-2.11*X[1]*X[11]*X[11]*X[11]	+7.17*X[2]*X[2]*X[3]*X[4]	+4.66*X[2]*X[2]*X[6]*X[11]	+3.32*X[2]*X[5]*X[6]*X[8]	+9.89*X[3]*X[4]*X[6]*X[11]	-8.53*X[3]*X[6]*X[7]*X[8]	+2.19*X[3]*X[7]*X[8]*X[10]	+8.77*X[4]*X[7]*X[9]*X[9];

subject to Constraint_1:
	-6.86*X[0]	+2.78*X[1]	-6.02*X[2]	+4.6*X[3]	+7.95*X[4]	+0.4*X[5]	+8.43*X[6]	-9.95*X[7]	+5.2*X[8]	+0.26*X[9]	+6.88*X[10]	+8.12*X[11]	+8.25*X[4]*X[8]	-0.44*X[11]*X[11] >= 45.767;

subject to Constraint_2:
	+6.09*X[0]	+9.03*X[1]	+4.5*X[2]	+1.31*X[3]	+3.92*X[4]	+3.57*X[5]	+2.73*X[6]	+8.26*X[7]	+5.67*X[8]	+1.96*X[9]	+7.99*X[10]	+5.58*X[11]	+9.55*X[4]*X[8]	+3.27*X[11]*X[11]	+7.75*X[0]*X[11]*X[11]	+1.72*X[1]*X[6]*X[7]	+3.49*X[2]*X[5]*X[5]	-6.29*X[3]*X[4]*X[11] >= 142.297;

subject to Constraint_3:
	+9.23*X[0]	+5.69*X[1]	+3.08*X[2]	+1.58*X[3]	+8.11*X[4]	+4.79*X[5]	+0.89*X[6]	+4.76*X[7]	-8.35*X[8]	+3.52*X[9]	+6.95*X[10]	-1.14*X[11]	+3.35*X[4]*X[8]	+3.81*X[11]*X[11]	+0.5*X[0]*X[11]*X[11]	+1.49*X[1]*X[6]*X[7]	+8.32*X[2]*X[5]*X[5]	+6.42*X[3]*X[4]*X[11]	+3*X[0]*X[0]*X[7]*X[11]	+9.16*X[0]*X[1]*X[4]*X[7]	+3.94*X[0]*X[2]*X[9]*X[9]	+3.71*X[0]*X[2]*X[9]*X[11]	-2.43*X[1]*X[11]*X[11]*X[11]	+8.33*X[2]*X[2]*X[3]*X[4]	-1.2*X[2]*X[2]*X[6]*X[11]	-3.49*X[2]*X[5]*X[6]*X[8]	+8.73*X[3]*X[4]*X[6]*X[11]	+3.65*X[3]*X[6]*X[7]*X[8]	+7.57*X[3]*X[7]*X[8]*X[10]	+4.31*X[4]*X[7]*X[9]*X[9] >= 315.888;

subject to Constraint_4:
	+4.87*X[0]	+5.57*X[1]	-8.24*X[2]	+8.64*X[3]	-7.61*X[4]	+4.08*X[5]	+5.27*X[6]	+7.99*X[7]	+4.72*X[8]	+9.27*X[9]	+2.93*X[10]	+2.56*X[11]	+1.84*X[11]*X[11]	-9.34*X[4]*X[8] >= 55.615;

subject to Constraint_5:
	+8.12*X[0]	+6.5*X[3]	-7.55*X[5]	+8.86*X[6]	+6.59*X[7]	+0.94*X[11] = 39.905;

subject to Constraint_6:
	+1.15*X[0]	+8.31*X[4]	+9.36*X[5]	+9.47*X[6]	+3.59*X[8]	+8.31*X[11] = 60.754;

subject to Constraint_7:
	+8.95*X[2]	+9.53*X[5]	+7.15*X[6]	+4.57*X[8]	+9.04*X[9]	+6.39*X[11] = 72.174;

subject to Constraint_8:
	+0.14*X[1]	-1.35*X[2]	+3.14*X[3]	+4.13*X[4]	+3.5*X[5]	+0.93*X[9] = 13.867;

subject to Constraint_9:
	+0.31*X[0]	+3.36*X[4]	+7.31*X[6]	+2.36*X[7]	+5.22*X[8]	-8.91*X[10] = 15.254;

subject to Constraint_10:
	+6.95*X[0]	+3.52*X[1]	+4.11*X[2]	+1*X[5]	+9.86*X[6]	+4.76*X[9] = 50.668;

subject to Constraint_11:
	+9.22*X[0]	+5.33*X[1]	-1.15*X[2]	-1.54*X[3]	-0.35*X[4]	+5.96*X[5]	+9.58*X[6]	+6.53*X[7]	+7.67*X[8]	+0.16*X[9]	-5.12*X[10]	+6.1*X[11] >= 67.301;

subject to Constraint_12:
	+0.6*X[0]	+1.02*X[1]	+4.37*X[2]	+1.82*X[3]	+3.51*X[4]	+9.67*X[5]	+5.39*X[6]	+6.52*X[7]	+8.93*X[8]	+5.48*X[9]	+6.79*X[10]	+2.71*X[11] >= 86.746;

