set VARS := 0..11;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.01;
let ub[0] := 2.17;
let lb[1] := 0.85;
let ub[1] := 2.08;
let lb[2] := 0.99;
let ub[2] := 2.68;
let lb[3] := 0.29;
let ub[3] := 2.96;
let lb[4] := 0.45;
let ub[4] := 2.91;
let lb[5] := 0.97;
let ub[5] := 2.18;
let lb[6] := 0.86;
let ub[6] := 2.99;
let lb[7] := 0.48;
let ub[7] := 2.63;
let lb[8] := 0.07;
let ub[8] := 2.14;
let lb[9] := 0.19;
let ub[9] := 2.45;
let lb[10] := 0.45;
let ub[10] := 2.49;
let lb[11] := 0.6;
let ub[11] := 2.07;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+2.91*X[0]	+7.13*X[1]	+8.43*X[2]	+8.12*X[3]	+0.56*X[4]	+1*X[5]	+2.49*X[6]	+8.18*X[7]	+9.64*X[8]	+3.01*X[9]	+3.18*X[10]	+3.94*X[11]	+9.53*X[0]*X[9]*X[11]	+2.22*X[0]*X[1]*X[7]*X[10]	+2.3*X[0]*X[2]*X[2]*X[7]	+2.29*X[0]*X[2]*X[5]*X[9]	-8.39*X[0]*X[2]*X[5]*X[10]	+8.9*X[1]*X[1]*X[2]*X[7]	+4.69*X[1]*X[1]*X[3]*X[9]	+0.1*X[1]*X[2]*X[8]*X[11]	+7.04*X[1]*X[4]*X[5]*X[5]	+9.98*X[1]*X[4]*X[6]*X[11]	+7.85*X[2]*X[2]*X[3]*X[4]	+0.43*X[3]*X[4]*X[8]*X[10]	-4.2*X[3]*X[5]*X[9]*X[9]	+5.83*X[4]*X[4]*X[9]*X[11]	+2.7*X[5]*X[9]*X[11]*X[11]	-9.84*X[6]*X[6]*X[8]*X[10]	+2.91*X[7]*X[7]*X[7]*X[7]	+8.27*X[8]*X[9]*X[10]*X[10];

subject to Constraint_1:
	+0.11*X[0]	+0.73*X[1]	+5.85*X[2]	+4.92*X[3]	+9.08*X[4]	+3.85*X[5]	+1.7*X[6]	+9.42*X[7]	+3.82*X[8]	+9.22*X[9]	+4.94*X[10]	+0.31*X[11]	+0.79*X[0]*X[9]*X[11] >= 84.742;

subject to Constraint_2:
	+2.46*X[0]	+4.55*X[1]	+2.29*X[2]	+6.79*X[3]	+4.91*X[4]	+3.08*X[5]	+4.74*X[6]	+3.24*X[7]	+1.87*X[8]	+1.55*X[9]	+5.68*X[10]	+1.68*X[11]	+2.22*X[0]*X[9]*X[11]	+5.59*X[0]*X[1]*X[7]*X[10]	+6.93*X[0]*X[2]*X[2]*X[7]	+0.5*X[0]*X[2]*X[5]*X[9]	+9.23*X[0]*X[2]*X[5]*X[10]	-2.77*X[1]*X[1]*X[2]*X[7]	+0.59*X[1]*X[1]*X[3]*X[9]	+3.01*X[1]*X[2]*X[8]*X[11]	-2.61*X[1]*X[4]*X[5]*X[5]	+1.29*X[1]*X[4]*X[6]*X[11]	+6.71*X[2]*X[2]*X[3]*X[4]	+6.64*X[3]*X[4]*X[8]*X[10]	-1.87*X[3]*X[5]*X[9]*X[9]	+9.82*X[4]*X[4]*X[9]*X[11]	+2.24*X[5]*X[9]*X[11]*X[11]	+3.47*X[6]*X[6]*X[8]*X[10]	+0.85*X[7]*X[7]*X[7]*X[7]	+8.67*X[8]*X[9]*X[10]*X[10] >= 358.617;

subject to Constraint_3:
	+7.79*X[0]	+3.99*X[1]	-9.79*X[2]	+9.26*X[3]	+3.63*X[4]	+7.76*X[5]	+9.42*X[6]	+3.58*X[7]	-8.23*X[8]	+0.83*X[9]	+4.42*X[10]	+2.2*X[11] = 54.876;

subject to Constraint_4:
	+0.69*X[0]	+8.54*X[1]	+6.22*X[2]	+3.2*X[3]	+1*X[4]	+0.93*X[5]	+3.62*X[6]	+7.98*X[7]	+1.09*X[8]	-2.55*X[9]	+9.32*X[10]	+5.49*X[11] = 71.267;

subject to Constraint_5:
	+8.78*X[0]	+0.89*X[1]	-7.33*X[2]	+8.73*X[3]	+4.93*X[4]	+1.54*X[5]	+9.33*X[6]	+5.38*X[7]	+5.96*X[8]	+0.58*X[9]	+7.61*X[10]	+0.76*X[11] = 68.197;

subject to Constraint_6:
	+5.18*X[0]	-4.27*X[1]	+8.79*X[2]	+5.6*X[3]	+9.58*X[4]	+4.72*X[5]	-5.61*X[6]	+9.97*X[7]	-1.04*X[8]	+1.88*X[9]	+4.12*X[10]	-8.34*X[11] = 49.108;

subject to Constraint_7:
	-2.25*X[0]	+1.22*X[1]	+6.81*X[2]	-4.51*X[3]	-0.08*X[4]	+1.26*X[5]	+2.37*X[6]	-2.8*X[7]	+8.03*X[8]	+9.02*X[9]	-3.35*X[10]	+7.04*X[11] = 31.814;

subject to Constraint_8:
	+9.87*X[0]	+1.19*X[1]	+9.21*X[2]	+4.99*X[3]	+9.83*X[4]	+8.42*X[5]	+5.14*X[6]	+1.79*X[7]	+3.2*X[8]	+7.39*X[9]	+3.45*X[10]	+4.55*X[11] = 104.401;

subject to Constraint_9:
	+5.33*X[0]	+8.88*X[1]	+9.96*X[2]	+1.33*X[3]	+6.85*X[4]	+2.62*X[5]	+0.26*X[6]	-6.43*X[7]	+1.9*X[8]	+5.48*X[9]	+3.18*X[10]	+4.49*X[11] >= 65.395;

subject to Constraint_10:
	-4.24*X[0]	+3.77*X[1]	+8.77*X[2]	-5.01*X[3]	+8.67*X[4]	+5.84*X[5]	+7.65*X[6]	+4.73*X[7]	+7.82*X[8]	+2.81*X[9]	+8.32*X[10]	+4.09*X[11] >= 84.739;

subject to Constraint_11:
	+1.26*X[0]	+2*X[1]	+3.56*X[2]	+2.15*X[3]	-6.36*X[4]	+0.14*X[5]	+1.26*X[6]	+2.21*X[7]	+1.4*X[8]	+9.47*X[9]	+0.74*X[10]	-3.31*X[11] >= 20.444;

subject to Constraint_12:
	+5.4*X[0]	+0.74*X[1]	+3.94*X[2]	+8.57*X[3]	+7.79*X[4]	+0.66*X[5]	+8.75*X[6]	+7.16*X[7]	+4.8*X[8]	+9.88*X[9]	+1.06*X[10]	+2.89*X[11] >= 93.992;

