set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.35;
let ub[0] := 2.27;
let lb[1] := 0.34;
let ub[1] := 2.09;
let lb[2] := 0.27;
let ub[2] := 2.75;
let lb[3] := 0.75;
let ub[3] := 2.32;
let lb[4] := 0.76;
let ub[4] := 2.81;
let lb[5] := 0.8;
let ub[5] := 2.14;
let lb[6] := 0.5;
let ub[6] := 2.87;
let lb[7] := 0.2;
let ub[7] := 2.89;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+6.22*X[0]	-6.94*X[1]	+6.13*X[2]	+9.38*X[3]	+4.06*X[4]	+3.97*X[5]	+2.62*X[6]	+7.41*X[7]	+0.38*X[2]*X[2]*X[2]*X[4]	-0.73*X[0]*X[1]*X[1]*X[2]*X[4]	+1.86*X[0]*X[1]*X[3]*X[5]*X[6]	+1.76*X[0]*X[1]*X[5]*X[7]*X[7]	+2.21*X[1]*X[4]*X[6]*X[7]*X[7]	+9.93*X[2]*X[2]*X[2]*X[2]*X[4];

subject to Constraint_1:
	+1.81*X[0]	+6.17*X[1]	+9.53*X[2]	+2.14*X[3]	+1.99*X[4]	+6.43*X[5]	+1.58*X[6]	+6.04*X[7]	+0.54*X[2]*X[2]*X[2]*X[4] >= 55.86;

subject to Constraint_2:
	+4.84*X[0]	+7.56*X[1]	+5.64*X[2]	+8.81*X[3]	+1.8*X[4]	+4.91*X[5]	+2.44*X[6]	-0.4*X[7]	+0.35*X[2]*X[2]*X[2]*X[4]	-7.33*X[0]*X[1]*X[1]*X[2]*X[4]	+6.62*X[0]*X[1]*X[3]*X[5]*X[6]	+9.45*X[0]*X[1]*X[5]*X[7]*X[7]	+1.05*X[1]*X[4]*X[6]*X[7]*X[7]	-8.68*X[2]*X[2]*X[2]*X[2]*X[4] >= 36.883;

subject to Constraint_3:
	+3.23*X[0]	+2.56*X[1]	+2.13*X[2]	+6.6*X[3]	+9.74*X[4]	+4.9*X[5]	+9.67*X[6]	+1.15*X[7] >= 63.349;

subject to Constraint_4:
	+5.02*X[0]	+2.43*X[1]	+4.08*X[2]	+3.58*X[3]	+1.75*X[4]	+2.27*X[5]	-8.19*X[6]	+9.02*X[7] >= 27.781;

subject to Constraint_5:
	+1.14*X[0]	+1.12*X[1]	+3.68*X[2]	+4.48*X[3]	+3.81*X[4]	+2.66*X[5]	+7.5*X[6]	+6.84*X[7] >= 49.204;

