set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.77;
let ub[0] := 2.69;
let lb[1] := 0.94;
let ub[1] := 2.04;
let lb[2] := 0.1;
let ub[2] := 2.5;
let lb[3] := 0.19;
let ub[3] := 2.92;
let lb[4] := 0.4;
let ub[4] := 2.17;
let lb[5] := 0.18;
let ub[5] := 2.68;
let lb[6] := 0.69;
let ub[6] := 2.21;
let lb[7] := 0.2;
let ub[7] := 2.47;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+5.96*X[0]	-5.27*X[1]	+7.36*X[2]	-6.18*X[3]	+0.54*X[4]	+2.45*X[5]	+7.83*X[6]	+0.63*X[7]	+7.51*X[3]*X[7]	+8.98*X[0]*X[2]*X[7]*X[7]	+7.91*X[1]*X[1]*X[1]*X[2]	+7.07*X[2]*X[3]*X[3]*X[7]	+5.95*X[2]*X[5]*X[5]*X[5]	+4.85*X[0]*X[0]*X[2]*X[3]*X[6]	+1.56*X[0]*X[2]*X[3]*X[3]*X[4]	+5.38*X[1]*X[1]*X[2]*X[2]*X[7]	+4.7*X[1]*X[2]*X[5]*X[7]*X[7]	+0.22*X[2]*X[2]*X[4]*X[4]*X[4]	+6.44*X[3]*X[3]*X[5]*X[5]*X[6]	+1.58*X[3]*X[4]*X[5]*X[6]*X[7]	+0.64*X[3]*X[6]*X[6]*X[7]*X[7];

subject to Constraint_1:
	+8.17*X[0]	+2.97*X[1]	+4.94*X[2]	+1.06*X[3]	+2.93*X[4]	+8.7*X[5]	+5.57*X[6]	+6.98*X[7]	+4.66*X[3]*X[7] >= 69.904;

subject to Constraint_2:
	+2.01*X[0]	+3.38*X[1]	+4.1*X[2]	+0.62*X[3]	+9.62*X[4]	+0.87*X[5]	+2.37*X[6]	+8.65*X[7]	+5.86*X[3]*X[7] >= 55.563;

subject to Constraint_3:
	+1.5*X[0]	+3.06*X[1]	+0.77*X[2]	-5.36*X[3]	-3.97*X[4]	+7.04*X[5]	+8.11*X[6]	+7.03*X[7]	-7.73*X[3]*X[7]	+4.39*X[0]*X[2]*X[7]*X[7]	+7*X[1]*X[1]*X[1]*X[2]	+9.18*X[2]*X[3]*X[3]*X[7]	+9.71*X[2]*X[5]*X[5]*X[5] >= 133.018;

subject to Constraint_4:
	+5.18*X[0]	+6.37*X[1]	-6.05*X[2]	+2.37*X[3]	+1.57*X[4]	+6.39*X[5]	+5.43*X[6]	+2.94*X[7]	+1.14*X[3]*X[7]	+8.34*X[0]*X[2]*X[7]*X[7]	+7.67*X[1]*X[1]*X[1]*X[2]	+3.91*X[2]*X[3]*X[3]*X[7]	+1.41*X[2]*X[5]*X[5]*X[5]	+5.74*X[0]*X[0]*X[2]*X[3]*X[6]	+5.84*X[0]*X[2]*X[3]*X[3]*X[4]	+4.8*X[1]*X[1]*X[2]*X[2]*X[7]	+5.72*X[1]*X[2]*X[5]*X[7]*X[7]	+6.74*X[2]*X[2]*X[4]*X[4]*X[4]	+7.16*X[3]*X[3]*X[5]*X[5]*X[6]	+5.19*X[3]*X[4]*X[5]*X[6]*X[7]	+0.25*X[3]*X[6]*X[6]*X[7]*X[7] >= 376.886;

subject to Constraint_5:
	+0.26*X[0]	-7.92*X[1]	+3.4*X[2]	+8.29*X[3]	+1.29*X[4]	+4.23*X[5]	+6.99*X[6]	+0.6*X[7] >= 24.603;

