set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.26;
let ub[0] := 2.97;
let lb[1] := 0.27;
let ub[1] := 2.11;
let lb[2] := 0.93;
let ub[2] := 2.21;
let lb[3] := 0.49;
let ub[3] := 2.59;
let lb[4] := 0.08;
let ub[4] := 2.76;
let lb[5] := 0.41;
let ub[5] := 2.39;
let lb[6] := 0.26;
let ub[6] := 2.83;
let lb[7] := 0.31;
let ub[7] := 2.36;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+9.67*X[0]	+9.36*X[1]	+0.33*X[2]	+4.07*X[3]	+7.62*X[4]	+7.77*X[5]	+0.37*X[6]	+3.1*X[7]	+2.69*X[1]*X[2]*X[5]*X[6]	+0.21*X[3]*X[3]*X[6]*X[7]	+2.1*X[0]*X[0]*X[0]*X[0]*X[1]	+1.57*X[0]*X[0]*X[0]*X[5]*X[7]	+5.18*X[0]*X[1]*X[1]*X[4]*X[4]	+5.84*X[3]*X[4]*X[5]*X[5]*X[6];

subject to Constraint_1:
	-9.05*X[0]	+5.44*X[1]	+5.33*X[2]	+9.91*X[3]	+3.92*X[4]	+7.97*X[5]	+1.85*X[6]	+4.6*X[7]	+0.68*X[3]*X[3]*X[6]*X[7]	-8.8*X[1]*X[2]*X[5]*X[6] >= 8.975;

subject to Constraint_2:
	+5.81*X[0]	+3.57*X[1]	-3.12*X[2]	+0.9*X[3]	+6.46*X[4]	+8.98*X[5]	+5.61*X[6]	+2.53*X[7]	+4.38*X[1]*X[2]*X[5]*X[6]	+7.25*X[3]*X[3]*X[6]*X[7]	+6.14*X[0]*X[0]*X[0]*X[0]*X[1]	+1.77*X[0]*X[0]*X[0]*X[5]*X[7]	+3.83*X[0]*X[1]*X[1]*X[4]*X[4]	+0.55*X[3]*X[4]*X[5]*X[5]*X[6] >= 182.018;

subject to Constraint_3:
	+2.69*X[3]	+9.5*X[5]	+3.93*X[6]	+8.11*X[7] = 34.341;

subject to Constraint_4:
	+7.8*X[3]	+1.06*X[4]	+9.24*X[5]	+4.77*X[7] = 32.821;

subject to Constraint_5:
	-3.63*X[0]	+7.2*X[1]	+6.15*X[2]	-5.3*X[3]	+9.82*X[4]	+5.2*X[5]	+4.31*X[6]	+6.28*X[7] >= 40.466;

subject to Constraint_6:
	+4.66*X[0]	+8.13*X[1]	+5.94*X[2]	+5.28*X[3]	+8.45*X[4]	-6.35*X[5]	+2.47*X[6]	+9.09*X[7] >= 53.718;

subject to Constraint_7:
	+6.55*X[0]	+8.08*X[1]	-8.6*X[2]	+6.34*X[3]	+3.6*X[4]	+7.72*X[5]	+7.18*X[6]	+1.46*X[7] >= 45.417;

