set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.55;
let ub[0] := 2.28;
let lb[1] := 0.05;
let ub[1] := 2.01;
let lb[2] := 0.42;
let ub[2] := 2.44;
let lb[3] := 0.81;
let ub[3] := 2.37;
let lb[4] := 0.36;
let ub[4] := 2.74;
let lb[5] := 0.98;
let ub[5] := 2.29;
let lb[6] := 0.39;
let ub[6] := 2.98;
let lb[7] := 0.17;
let ub[7] := 2.4;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+4.79*X[0]	+3.48*X[1]	+6.39*X[2]	-4.55*X[3]	+6.91*X[4]	+6.15*X[5]	+6.27*X[6]	+5.41*X[7]	+8.4*X[0]*X[6]*X[7]*X[7]	+4.99*X[4]*X[4]*X[6]*X[7]	+2.64*X[0]*X[1]*X[1]*X[6]*X[6]	-8.09*X[1]*X[1]*X[1]*X[5]*X[6]	+1.5*X[1]*X[1]*X[3]*X[3]*X[5]	+1.3*X[1]*X[2]*X[5]*X[5]*X[5];

subject to Constraint_1:
	+3.32*X[0]	+8.12*X[1]	+1.82*X[2]	+7.97*X[3]	+5.28*X[4]	+4.96*X[5]	+6.94*X[6]	+3.42*X[7]	+1.74*X[0]*X[6]*X[7]*X[7]	+9.88*X[4]*X[4]*X[6]*X[7] >= 118.964;

subject to Constraint_2:
	+7.44*X[0]	+5.78*X[1]	+1.86*X[2]	+5.25*X[3]	+5.34*X[4]	+9.48*X[5]	+2.36*X[6]	+4.16*X[7]	+1.56*X[0]*X[6]*X[7]*X[7]	+1.77*X[4]*X[4]*X[6]*X[7]	+8.03*X[0]*X[1]*X[1]*X[6]*X[6]	+4.97*X[1]*X[1]*X[1]*X[5]*X[6]	+7.1*X[1]*X[1]*X[3]*X[3]*X[5]	+2.96*X[1]*X[2]*X[5]*X[5]*X[5] >= 175.314;

subject to Constraint_3:
	-4.64*X[0]	-3.21*X[1]	-3.49*X[2]	+1.42*X[3]	+10*X[4]	+9.39*X[5]	+9.87*X[6]	+2.56*X[7] = 38.168;

subject to Constraint_4:
	+6.65*X[0]	+2.62*X[1]	+5.96*X[2]	+4.15*X[3]	+1.57*X[4]	+9.13*X[5]	-6.91*X[6]	+9.84*X[7] = 45.592;

subject to Constraint_5:
	+8.74*X[0]	+0.08*X[1]	+8.36*X[2]	+9.61*X[3]	+0.2*X[4]	+8.99*X[5]	+1.23*X[6]	+6.75*X[7] >= 65.439;

subject to Constraint_6:
	+9.54*X[0]	-8.34*X[1]	+8.95*X[2]	+0.55*X[3]	+1.08*X[4]	+2.18*X[5]	+3.76*X[6]	-2.5*X[7] >= 26.943;

subject to Constraint_7:
	+9.95*X[0]	+4.13*X[1]	+6.27*X[2]	+1.95*X[3]	+5.04*X[4]	+4.39*X[5]	+9.11*X[6]	+8.92*X[7] >= 72.202;

