set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.31;
let ub[0] := 2.13;
let lb[1] := 0.07;
let ub[1] := 2.28;
let lb[2] := 0.62;
let ub[2] := 2.94;
let lb[3] := 0.65;
let ub[3] := 2.77;
let lb[4] := 0.56;
let ub[4] := 2.53;
let lb[5] := 0.81;
let ub[5] := 2.05;
let lb[6] := 0.7;
let ub[6] := 2.31;
let lb[7] := 0.47;
let ub[7] := 2.5;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+1.87*X[0]	+4.94*X[1]	+5.83*X[2]	+6.68*X[3]	+4.81*X[4]	-3.83*X[5]	+6.41*X[6]	+1.11*X[7]	+8.67*X[1]*X[5]*X[6]	+1.45*X[0]*X[0]*X[3]*X[6]	+4.49*X[3]*X[3]*X[5]*X[6]	+8.85*X[0]*X[0]*X[0]*X[3]*X[3]	+9.47*X[1]*X[4]*X[5]*X[5]*X[7]	+0.85*X[2]*X[6]*X[6]*X[7]*X[7];

subject to Constraint_1:
	+2.89*X[0]	+4.88*X[1]	+2.97*X[2]	+8.49*X[3]	+5.21*X[4]	+7.69*X[5]	+4.75*X[6]	+6.92*X[7]	+4.01*X[1]*X[5]*X[6] >= 75.676;

subject to Constraint_2:
	+0.49*X[0]	+5.2*X[1]	+7.86*X[2]	+9.88*X[3]	+2.26*X[4]	+9.68*X[5]	+9.48*X[6]	+7.13*X[7]	+8.08*X[1]*X[5]*X[6]	+0.79*X[0]*X[0]*X[3]*X[6]	+7.87*X[3]*X[3]*X[5]*X[6] >= 152.768;

subject to Constraint_3:
	+3.67*X[0]	-8.05*X[1]	+8.93*X[2]	+1.58*X[3]	+2.16*X[4]	+7.49*X[5]	+4.01*X[6]	+7.45*X[7]	+2.41*X[1]*X[5]*X[6]	-8.42*X[0]*X[0]*X[3]*X[6]	+8.48*X[3]*X[3]*X[5]*X[6]	+7.7*X[0]*X[0]*X[0]*X[3]*X[3]	+4.98*X[1]*X[4]*X[5]*X[5]*X[7]	+2.19*X[2]*X[6]*X[6]*X[7]*X[7] >= 159.779;

subject to Constraint_4:
	+9.33*X[0]	+8.59*X[2]	+9.86*X[5]	+1.5*X[7] = 43;

subject to Constraint_5:
	-7.24*X[0]	+0.81*X[1]	+9.23*X[2]	+0.81*X[4] = 9.8;

subject to Constraint_6:
	+9.63*X[0]	+9.91*X[2]	+0.53*X[4]	+0.23*X[7] = 30.549;

subject to Constraint_7:
	+7.56*X[0]	-7.51*X[3]	+2.28*X[5]	+6.5*X[6] = 9.424;

subject to Constraint_8:
	+9.3*X[0]	+0.75*X[1]	+6.69*X[2]	-1.93*X[3]	-2.63*X[4]	+4.88*X[5]	+9.63*X[6]	+4.03*X[7] >= 44.228;

subject to Constraint_9:
	+3.57*X[0]	+8.75*X[1]	+6.12*X[2]	+7.28*X[3]	+1.6*X[4]	+1.45*X[5]	+2.54*X[6]	-8.97*X[7] >= 33.027;

