set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.32;
let ub[0] := 2.92;
let lb[1] := 0.47;
let ub[1] := 2.06;
let lb[2] := 0.33;
let ub[2] := 2.5;
let lb[3] := 0.33;
let ub[3] := 2.64;
let lb[4] := 0.39;
let ub[4] := 2.19;
let lb[5] := 0.83;
let ub[5] := 2.51;
let lb[6] := 0.99;
let ub[6] := 2.48;
let lb[7] := 0.37;
let ub[7] := 2.69;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+1.14*X[0]	+1.07*X[1]	+5.65*X[2]	+9.43*X[3]	-4.52*X[4]	+3.51*X[5]	+3.94*X[6]	+5.68*X[7]	+6.62*X[0]*X[3]*X[4]*X[4]	+1.82*X[0]*X[3]*X[5]*X[5]	+7.33*X[2]*X[2]*X[5]*X[7]	+3.19*X[0]*X[0]*X[1]*X[2]*X[6]	+2.93*X[0]*X[1]*X[1]*X[4]*X[4]	+9.41*X[2]*X[2]*X[4]*X[5]*X[7];

subject to Constraint_1:
	+4.26*X[0]	+4.87*X[1]	+4.92*X[2]	+8.9*X[3]	-3.01*X[4]	+5.05*X[5]	+7.65*X[6]	+8.95*X[7]	+2.8*X[0]*X[3]*X[4]*X[4]	+4.4*X[0]*X[3]*X[5]*X[5]	+6.41*X[2]*X[2]*X[5]*X[7] >= 138.28;

subject to Constraint_2:
	+8.31*X[0]	+7.93*X[1]	+0.44*X[2]	+8.1*X[3]	+4.34*X[4]	+0.25*X[5]	+1.19*X[6]	+6.99*X[7]	+2.98*X[0]*X[3]*X[4]*X[4]	+1.56*X[0]*X[3]*X[5]*X[5]	+6.67*X[2]*X[2]*X[5]*X[7]	+7.7*X[0]*X[0]*X[1]*X[2]*X[6]	+5.87*X[0]*X[1]*X[1]*X[4]*X[4]	+7.24*X[2]*X[2]*X[4]*X[5]*X[7] >= 247.3;

subject to Constraint_3:
	+3.28*X[0]	+2.23*X[1]	+3.46*X[2]	+5.46*X[3]	+0.41*X[4]	+8.99*X[5]	+8.59*X[6]	+6.3*X[7] = 61.223;

subject to Constraint_4:
	+5.53*X[0]	+2.27*X[1]	+8.66*X[2]	+1.23*X[3]	+3.41*X[4]	+8.7*X[5]	+9.44*X[6]	+8.53*X[7] = 74.268;

subject to Constraint_5:
	-1.59*X[0]	+4.87*X[1]	+4.85*X[2]	+6.49*X[3]	+7.4*X[4]	+6.89*X[5]	+1.52*X[6]	+0.72*X[7] = 44.876;

subject to Constraint_6:
	+7.42*X[0]	+6.02*X[1]	+2.06*X[2]	+1.14*X[3]	+4.64*X[4]	-4.36*X[5]	+3.23*X[6]	+7.79*X[7] = 40.471;

subject to Constraint_7:
	+2.6*X[0]	+8.06*X[1]	+2.35*X[2]	+2.56*X[3]	+7.21*X[4]	+7.5*X[5]	-6.96*X[6]	+5.07*X[7] >= 39.042;

subject to Constraint_8:
	+9.91*X[0]	+9.02*X[1]	+9.37*X[2]	+5.07*X[3]	+9.66*X[4]	+7.23*X[5]	+5.61*X[6]	+6.73*X[7] >= 92.818;

subject to Constraint_9:
	+4.96*X[0]	+4.87*X[1]	+7.24*X[2]	+6.7*X[3]	+8.69*X[4]	-6.74*X[5]	+6.86*X[6]	+3.6*X[7] >= 51.754;

