set VARS := 0..7;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.05;
let ub[0] := 2.7;
let lb[1] := 0.96;
let ub[1] := 2.7;
let lb[2] := 0.15;
let ub[2] := 2.56;
let lb[3] := 0.29;
let ub[3] := 2.03;
let lb[4] := 0.19;
let ub[4] := 2.42;
let lb[5] := 0.45;
let ub[5] := 2.05;
let lb[6] := 0.2;
let ub[6] := 2.33;
let lb[7] := 0.58;
let ub[7] := 2.19;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+7.77*X[0]	+0.89*X[1]	+7.17*X[2]	+2*X[3]	+2.89*X[4]	+0.4*X[5]	+8.76*X[6]	+2.07*X[7]	+3.42*X[7]*X[7]*X[7]	+8.57*X[0]*X[4]*X[5]*X[7]	+4.04*X[3]*X[3]*X[7]*X[7]	+2.64*X[0]*X[0]*X[1]*X[5]*X[7]	+9.23*X[1]*X[1]*X[1]*X[3]*X[5]	+6.95*X[1]*X[1]*X[2]*X[3]*X[7]	+0.23*X[1]*X[2]*X[2]*X[2]*X[5]	+7.55*X[2]*X[2]*X[3]*X[5]*X[5]	+4.54*X[2]*X[3]*X[4]*X[6]*X[6]	+8.63*X[2]*X[4]*X[4]*X[7]*X[7]	+0.87*X[3]*X[3]*X[3]*X[5]*X[7]	+9.98*X[3]*X[3]*X[5]*X[6]*X[7]	+9.68*X[3]*X[3]*X[6]*X[7]*X[7];

subject to Constraint_1:
	+0.07*X[0]	+2.81*X[1]	-8.44*X[2]	+9.9*X[3]	+5.78*X[4]	+6.09*X[5]	+6.18*X[6]	+5.85*X[7]	+9.76*X[7]*X[7]*X[7] >= 62.291;

subject to Constraint_2:
	+0.78*X[0]	+5.02*X[1]	+3.01*X[2]	+1.41*X[3]	+0.78*X[4]	+2.45*X[5]	-9.21*X[6]	+4.76*X[7]	+3.88*X[7]*X[7]*X[7]	+3.25*X[0]*X[4]*X[5]*X[7]	+0.23*X[3]*X[3]*X[7]*X[7] >= 35.994;

subject to Constraint_3:
	+7.83*X[0]	+6.44*X[1]	+1.98*X[2]	+2.65*X[3]	+8.32*X[4]	+4.39*X[5]	+1.81*X[6]	+2.94*X[7]	+5.52*X[7]*X[7]*X[7]	+0.48*X[0]*X[4]*X[5]*X[7]	+9.58*X[3]*X[3]*X[7]*X[7]	+2.83*X[0]*X[0]*X[1]*X[5]*X[7]	+8.47*X[1]*X[1]*X[1]*X[3]*X[5]	+7.68*X[1]*X[1]*X[2]*X[3]*X[7]	+7.01*X[1]*X[2]*X[2]*X[2]*X[5]	+0.89*X[2]*X[2]*X[3]*X[5]*X[5]	+0.37*X[2]*X[3]*X[4]*X[6]*X[6]	+9*X[2]*X[4]*X[4]*X[7]*X[7]	+8.33*X[3]*X[3]*X[3]*X[5]*X[7]	+0.41*X[3]*X[3]*X[5]*X[6]*X[7]	-9.26*X[3]*X[3]*X[6]*X[7]*X[7] >= 317.498;

subject to Constraint_4:
	+7.05*X[0]	+6.89*X[2]	+7.05*X[4]	+3.8*X[6] = 33.037;

subject to Constraint_5:
	+7.17*X[0]	+0.6*X[3]	+0.48*X[5]	+2.29*X[6] = 14.052;

subject to Constraint_6:
	+2.95*X[0]	+4.54*X[1]	+0.24*X[3]	+8.83*X[6] = 23.813;

subject to Constraint_7:
	+1.37*X[2]	+5.75*X[3]	+3.5*X[4]	+9.34*X[5] = 24.769;

subject to Constraint_8:
	+0.11*X[0]	+0.94*X[1]	+5.92*X[2]	+4.92*X[3]	+4.55*X[4]	+5.92*X[5]	+7.63*X[6]	+5.26*X[7] >= 45.875;

subject to Constraint_9:
	+5.99*X[0]	+9.5*X[1]	+1.15*X[2]	+6.66*X[3]	+4.63*X[4]	+2.4*X[5]	+5.29*X[6]	+8.66*X[7] >= 62.633;

