set VARS := 0..4;

param lb {VARS};
param ub {VARS};
let lb[0] := 0.11;
let ub[0] := 2.04;
let lb[1] := 0.73;
let ub[1] := 2.06;
let lb[2] := 0.95;
let ub[2] := 2.95;
let lb[3] := 0.5;
let ub[3] := 2.84;
let lb[4] := 0.48;
let ub[4] := 2.14;

var X {i in VARS} >= lb[i], <= ub[i];

minimize Total_Cost:
	+4.47*X[0]	+2.18*X[1]	+7.26*X[2]	+5.81*X[3]	+5.72*X[4]	+6.27*X[3]*X[3]	+9.19*X[0]*X[1]*X[4]	+4.89*X[0]*X[2]*X[2]*X[2]*X[3]	+4.4*X[1]*X[1]*X[2]*X[3]*X[3]	+5.09*X[1]*X[2]*X[3]*X[3]*X[4]	-8.9*X[0]*X[0]*X[0]*X[1]*X[2]*X[3]	+6.13*X[0]*X[1]*X[1]*X[1]*X[2]*X[3]*X[4]	+7.39*X[2]*X[2]*X[3]*X[3]*X[3]*X[3]*X[3];

subject to Constraint_1:
	-9.89*X[0]	+4.19*X[1]	+2.68*X[2]	+1.63*X[3]	+7.27*X[4]	+8.54*X[3]*X[3] >= 36.502;

subject to Constraint_2:
	-2.39*X[0]	+4.15*X[1]	+7.91*X[2]	+8.37*X[3]	+1.11*X[4]	+0.07*X[3]*X[3]	+4*X[0]*X[1]*X[4] >= 42.13;

subject to Constraint_3:
	+6.17*X[0]	+7.27*X[1]	+9.18*X[2]	+0.96*X[3]	-6.16*X[4]	+6.78*X[0]*X[1]*X[4]	-7.36*X[3]*X[3] >= 21.002;

subject to Constraint_4:
	+6.25*X[0]	+3.4*X[1]	+7.95*X[2]	+0.9*X[3]	+4.42*X[4]	+9.14*X[3]*X[3]	+3.76*X[0]*X[1]*X[4]	+5.78*X[0]*X[2]*X[2]*X[2]*X[3]	+8.36*X[1]*X[1]*X[2]*X[3]*X[3]	-2.41*X[1]*X[2]*X[3]*X[3]*X[4] >= 208.599;

subject to Constraint_5:
	-8.81*X[0]	+4.75*X[1]	+4.34*X[2]	+7.01*X[3]	+9.53*X[4] = 29.809;

subject to Constraint_6:
	+5.49*X[0]	-4.32*X[1]	+1.71*X[2]	+6.04*X[3]	+7.23*X[4] >= 22.768;

